@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property parameters Array of processor parameters. More details are given below
 * @property type The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
 */
public data class FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs(
    public val parameters:
    Output<List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgsBuilder
internal constructor() {
    private var parameters:
        Output<List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Array of processor parameters. More details are given below
     */
    @JvmName("powhuupmyfvrowmm")
    public suspend
    fun parameters(`value`: Output<List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("dkfyrxnfiubgftss")
    public suspend fun parameters(
        vararg
        values: Output<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs>,
    ) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Array of processor parameters. More details are given below
     */
    @JvmName("ebacqqynhemjvcsk")
    public suspend
    fun parameters(values: List<Output<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("rmhemmgrknfuusek")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Array of processor parameters. More details are given below
     */
    @JvmName("srxcghnyxfcfbjlv")
    public suspend
    fun parameters(`value`: List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("amfufgtxocwthgos")
    public suspend
    fun parameters(argument: List<suspend FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("rntcvrvpeevwmqpd")
    public suspend fun parameters(
        vararg
        argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("okdxinompcmfqwoa")
    public suspend
    fun parameters(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Array of processor parameters. More details are given below
     */
    @JvmName("mqcvqhkvhrcvllgj")
    public suspend fun parameters(
        vararg
        values: FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("urkenjfuovuxnntn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs(
            parameters = parameters,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
