@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Array of data processors. More details are given below
 */
public data class FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors:
    Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("rhxubwmiwgjnhmgw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("wsmhsaftqdypllmq")
    public suspend
    fun processors(`value`: Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("fljwrbhcjfvsjhmt")
    public suspend fun processors(
        vararg
        values: Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs>,
    ) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("hodnocpbbfgtxedb")
    public suspend
    fun processors(values: List<Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("fhvmwwmmglivnnbj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("asghiqcmmlkbqwrs")
    public suspend
    fun processors(`value`: List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("ixqdmiinxjgecafr")
    public suspend
    fun processors(argument: List<suspend FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("lairdngynvsfgrik")
    public suspend fun processors(
        vararg
        argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("jsgtwhxfplhinyxl")
    public suspend
    fun processors(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("qwmogvlrnvfdmoug")
    public suspend fun processors(
        vararg
        values: FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
