@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property parameters Array of processor parameters. More details are given below
 * @property type The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
 */
public data class
FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs(
    public val parameters:
    Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgsBuilder
internal constructor() {
    private var parameters:
        Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Array of processor parameters. More details are given below
     */
    @JvmName("nrtesesofvcgobuw")
    public suspend
    fun parameters(`value`: Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("whhtwjohrlksjaiy")
    public suspend fun parameters(
        vararg
        values: Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgs>,
    ) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Array of processor parameters. More details are given below
     */
    @JvmName("rgnrjtutosjdifth")
    public suspend
    fun parameters(values: List<Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("ckbxahhfoxnveboy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Array of processor parameters. More details are given below
     */
    @JvmName("pawdtkkceomhgtir")
    public suspend
    fun parameters(`value`: List<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("gpvgvxxgwgcpcnto")
    public suspend
    fun parameters(argument: List<suspend FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("oasocnyvwcxqpcpq")
    public suspend fun parameters(
        vararg
        argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("buagmbsbchhbpyvm")
    public suspend
    fun parameters(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Array of processor parameters. More details are given below
     */
    @JvmName("gvgwjxidlqapclva")
    public suspend fun parameters(
        vararg
        values: FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorParameterArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("tsytbmirruuuaxuo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs =
        FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationProcessorArgs(
            parameters = parameters,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
