@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property commonAttributes Describes the metadata sent to the HTTP endpoint destination. More details are given below
 * @property contentEncoding Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination. Valid values are `NONE` and `GZIP`.  Default value is `NONE`.
 */
public data class FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs(
    public val commonAttributes:
    Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs>>? =
        null,
    public val contentEncoding: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs.builder()
            .commonAttributes(
                commonAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .contentEncoding(contentEncoding?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgsBuilder internal
constructor() {
    private var commonAttributes:
        Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs>>? =
        null

    private var contentEncoding: Output<String>? = null

    /**
     * @param value Describes the metadata sent to the HTTP endpoint destination. More details are given below
     */
    @JvmName("wvdnlfevtmobdjxa")
    public suspend
    fun commonAttributes(`value`: Output<List<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs>>) {
        this.commonAttributes = value
    }

    @JvmName("louosjtkoggxxtfh")
    public suspend fun commonAttributes(
        vararg
        values: Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs>,
    ) {
        this.commonAttributes = Output.all(values.asList())
    }

    /**
     * @param values Describes the metadata sent to the HTTP endpoint destination. More details are given below
     */
    @JvmName("dinlguihhwbnowyb")
    public suspend
    fun commonAttributes(values: List<Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs>>) {
        this.commonAttributes = Output.all(values)
    }

    /**
     * @param value Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination. Valid values are `NONE` and `GZIP`.  Default value is `NONE`.
     */
    @JvmName("uojnrnnxhjgjmawr")
    public suspend fun contentEncoding(`value`: Output<String>) {
        this.contentEncoding = value
    }

    /**
     * @param value Describes the metadata sent to the HTTP endpoint destination. More details are given below
     */
    @JvmName("oyrtdngvetesjvus")
    public suspend
    fun commonAttributes(`value`: List<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commonAttributes = mapped
    }

    /**
     * @param argument Describes the metadata sent to the HTTP endpoint destination. More details are given below
     */
    @JvmName("nkvrjrikngslytot")
    public suspend
    fun commonAttributes(argument: List<suspend FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.commonAttributes = mapped
    }

    /**
     * @param argument Describes the metadata sent to the HTTP endpoint destination. More details are given below
     */
    @JvmName("ahcmujntpakluiys")
    public suspend fun commonAttributes(
        vararg
        argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.commonAttributes = mapped
    }

    /**
     * @param argument Describes the metadata sent to the HTTP endpoint destination. More details are given below
     */
    @JvmName("uajxdnddkxcfyokr")
    public suspend
    fun commonAttributes(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.commonAttributes = mapped
    }

    /**
     * @param values Describes the metadata sent to the HTTP endpoint destination. More details are given below
     */
    @JvmName("yhbvnqslcogrwxjv")
    public suspend fun commonAttributes(
        vararg
        values: FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commonAttributes = mapped
    }

    /**
     * @param value Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination. Valid values are `NONE` and `GZIP`.  Default value is `NONE`.
     */
    @JvmName("iwgnnrdnoslyuwhi")
    public suspend fun contentEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentEncoding = mapped
    }

    internal fun build(): FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs =
        FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs(
            commonAttributes = commonAttributes,
            contentEncoding = contentEncoding,
        )
}
