@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kinesisStreamArn The kinesis stream used as the source of the firehose delivery stream.
 * @property roleArn The ARN of the role that provides access to the source Kinesis stream.
 */
public data class FirehoseDeliveryStreamKinesisSourceConfigurationArgs(
    public val kinesisStreamArn: Output<String>,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgs.builder()
            .kinesisStreamArn(kinesisStreamArn.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamKinesisSourceConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamKinesisSourceConfigurationArgsBuilder internal constructor() {
    private var kinesisStreamArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The kinesis stream used as the source of the firehose delivery stream.
     */
    @JvmName("lvbetsiavmuhsrox")
    public suspend fun kinesisStreamArn(`value`: Output<String>) {
        this.kinesisStreamArn = value
    }

    /**
     * @param value The ARN of the role that provides access to the source Kinesis stream.
     */
    @JvmName("jlpnghsritmgtjdp")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The kinesis stream used as the source of the firehose delivery stream.
     */
    @JvmName("pwpenqnynescpxfb")
    public suspend fun kinesisStreamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kinesisStreamArn = mapped
    }

    /**
     * @param value The ARN of the role that provides access to the source Kinesis stream.
     */
    @JvmName("tujjgxoqfhpmycug")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): FirehoseDeliveryStreamKinesisSourceConfigurationArgs =
        FirehoseDeliveryStreamKinesisSourceConfigurationArgs(
            kinesisStreamArn = kinesisStreamArn ?: throw PulumiNullFieldException("kinesisStreamArn"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
