@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectivity The type of connectivity used to access the Amazon MSK cluster. Valid values: `PUBLIC`, `PRIVATE`.
 * @property roleArn The ARN of the role used to access the Amazon MSK cluster.
 */
public data class FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs(
    public val connectivity: Output<String>,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs.builder()
            .connectivity(connectivity.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgsBuilder
internal constructor() {
    private var connectivity: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The type of connectivity used to access the Amazon MSK cluster. Valid values: `PUBLIC`, `PRIVATE`.
     */
    @JvmName("ybircnvjddgvuqxr")
    public suspend fun connectivity(`value`: Output<String>) {
        this.connectivity = value
    }

    /**
     * @param value The ARN of the role used to access the Amazon MSK cluster.
     */
    @JvmName("ifsyxbpidkyqlgmj")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The type of connectivity used to access the Amazon MSK cluster. Valid values: `PUBLIC`, `PRIVATE`.
     */
    @JvmName("iruweehdquwaumke")
    public suspend fun connectivity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivity = mapped
    }

    /**
     * @param value The ARN of the role used to access the Amazon MSK cluster.
     */
    @JvmName("tsyupvkxatwuxots")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs =
        FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs(
            connectivity = connectivity ?: throw PulumiNullFieldException("connectivity"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
