@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below
 * @property clusterEndpoint The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
 * @property domainArn The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
 * @property indexName The OpenSearch index name.
 * @property indexRotationPeriod The OpenSearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
 * @property processingConfiguration The data processing configuration.  More details are given below.
 * @property retryDuration After an initial failure to deliver to Amazon OpenSearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property roleArn The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeDomain`, `DescribeDomains`, and `DescribeDomainConfig`.  The pattern needs to be `arn:.*`.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
 * @property s3Configuration The S3 Configuration. See s3_configuration for more details.
 * @property typeName The Elasticsearch type name with maximum length of 100 characters. Types are deprecated in OpenSearch_1.1. TypeName must be empty.
 * @property vpcConfig The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. More details are given below
 */
public data class FirehoseDeliveryStreamOpensearchConfigurationArgs(
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions:
    Output<FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs>? = null,
    public val clusterEndpoint: Output<String>? = null,
    public val domainArn: Output<String>? = null,
    public val indexName: Output<String>,
    public val indexRotationPeriod: Output<String>? = null,
    public val processingConfiguration:
    Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs>? = null,
    public val retryDuration: Output<Int>? = null,
    public val roleArn: Output<String>,
    public val s3BackupMode: Output<String>? = null,
    public val s3Configuration:
    Output<FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs>,
    public val typeName: Output<String>? = null,
    public val vpcConfig: Output<FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
            .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
            .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterEndpoint(clusterEndpoint?.applyValue({ args0 -> args0 }))
            .domainArn(domainArn?.applyValue({ args0 -> args0 }))
            .indexName(indexName.applyValue({ args0 -> args0 }))
            .indexRotationPeriod(indexRotationPeriod?.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retryDuration(retryDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 }))
            .s3Configuration(s3Configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .typeName(typeName?.applyValue({ args0 -> args0 }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder internal constructor() {
    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs>? = null

    private var clusterEndpoint: Output<String>? = null

    private var domainArn: Output<String>? = null

    private var indexName: Output<String>? = null

    private var indexRotationPeriod: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs>? = null

    private var retryDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var s3BackupMode: Output<String>? = null

    private var s3Configuration:
        Output<FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs>? = null

    private var typeName: Output<String>? = null

    private var vpcConfig: Output<FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs>? = null

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("qvisxcnidfxcftac")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("shkxtkibukfjwdoi")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("ugkeadtfmpjdfvmu")
    public suspend
    fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
     */
    @JvmName("fgxtpfqmfppofnye")
    public suspend fun clusterEndpoint(`value`: Output<String>) {
        this.clusterEndpoint = value
    }

    /**
     * @param value The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
     */
    @JvmName("brmqoikorifpfsrm")
    public suspend fun domainArn(`value`: Output<String>) {
        this.domainArn = value
    }

    /**
     * @param value The OpenSearch index name.
     */
    @JvmName("pilwvrtnkdapfdsc")
    public suspend fun indexName(`value`: Output<String>) {
        this.indexName = value
    }

    /**
     * @param value The OpenSearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
     */
    @JvmName("rxykvnullymwuqkx")
    public suspend fun indexRotationPeriod(`value`: Output<String>) {
        this.indexRotationPeriod = value
    }

    /**
     * @param value The data processing configuration.  More details are given below.
     */
    @JvmName("rlevbipgbqunggvd")
    public suspend
    fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value After an initial failure to deliver to Amazon OpenSearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("xscqgsgmvtesfygr")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeDomain`, `DescribeDomains`, and `DescribeDomainConfig`.  The pattern needs to be `arn:.*`.
     */
    @JvmName("drrfhtwkhbbeeywr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("grlkfbdkmuflwqxd")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The S3 Configuration. See s3_configuration for more details.
     */
    @JvmName("lofxbtavhmsdanam")
    public suspend
    fun s3Configuration(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value The Elasticsearch type name with maximum length of 100 characters. Types are deprecated in OpenSearch_1.1. TypeName must be empty.
     */
    @JvmName("nyaifbrxmukubool")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. More details are given below
     */
    @JvmName("temphvuehoyxpqpk")
    public suspend
    fun vpcConfig(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("qoinrarxeqkqlnwp")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("qhoplitutlderupb")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("ponhibnnfuimholh")
    public suspend
    fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("jgujheneysguowhv")
    public suspend
    fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
     */
    @JvmName("qtvumnfmxbhmaunw")
    public suspend fun clusterEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterEndpoint = mapped
    }

    /**
     * @param value The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
     */
    @JvmName("sbtykihsyrbjlexb")
    public suspend fun domainArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainArn = mapped
    }

    /**
     * @param value The OpenSearch index name.
     */
    @JvmName("cgelcicackciaylp")
    public suspend fun indexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexName = mapped
    }

    /**
     * @param value The OpenSearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
     */
    @JvmName("siuqldrwisreubka")
    public suspend fun indexRotationPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexRotationPeriod = mapped
    }

    /**
     * @param value The data processing configuration.  More details are given below.
     */
    @JvmName("irwbfjqimrirqkin")
    public suspend
    fun processingConfiguration(`value`: FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration.  More details are given below.
     */
    @JvmName("nfccelfwynqjmtgw")
    public suspend
    fun processingConfiguration(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value After an initial failure to deliver to Amazon OpenSearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("hjncoiwugpacggnx")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeDomain`, `DescribeDomains`, and `DescribeDomainConfig`.  The pattern needs to be `arn:.*`.
     */
    @JvmName("rngxlpiimlrqledy")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("bheorlxliomtlbnl")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    /**
     * @param value The S3 Configuration. See s3_configuration for more details.
     */
    @JvmName("tuhdruvnnhtwhbpr")
    public suspend
    fun s3Configuration(`value`: FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The S3 Configuration. See s3_configuration for more details.
     */
    @JvmName("ucwxijjulimknnlm")
    public suspend
    fun s3Configuration(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value The Elasticsearch type name with maximum length of 100 characters. Types are deprecated in OpenSearch_1.1. TypeName must be empty.
     */
    @JvmName("hcvdnfbqddsxuhil")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. More details are given below
     */
    @JvmName("aajuvnbpwcbiwmod")
    public suspend
    fun vpcConfig(`value`: FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. More details are given below
     */
    @JvmName("svrskvishollapgr")
    public suspend
    fun vpcConfig(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchConfigurationArgs =
        FirehoseDeliveryStreamOpensearchConfigurationArgs(
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            clusterEndpoint = clusterEndpoint,
            domainArn = domainArn,
            indexName = indexName ?: throw PulumiNullFieldException("indexName"),
            indexRotationPeriod = indexRotationPeriod,
            processingConfiguration = processingConfiguration,
            retryDuration = retryDuration,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            s3BackupMode = s3BackupMode,
            s3Configuration = s3Configuration ?: throw PulumiNullFieldException("s3Configuration"),
            typeName = typeName,
            vpcConfig = vpcConfig,
        )
}
