@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Array of data processors. More details are given below
 */
public data class
FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors:
    Output<List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("apgaqpwoaralybdq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("uubcvoosblbdketr")
    public suspend
    fun processors(`value`: Output<List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("dpmysjofrkpystkp")
    public suspend fun processors(
        vararg
        values: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>,
    ) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("tnqmkcfffsrondgc")
    public suspend
    fun processors(values: List<Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("gmtduhuslvdsxnll")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("pemcfionxtlthrbl")
    public suspend
    fun processors(`value`: List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("rbrlwudplmmhufoe")
    public suspend
    fun processors(argument: List<suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("yyoqndjmvremhxoj")
    public suspend fun processors(
        vararg
        argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("pmpydxggedxsqbqe")
    public suspend
    fun processors(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("cnltuwqkfrdpmupf")
    public suspend fun processors(
        vararg
        values: FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
