@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below
 * @property clusterJdbcurl The jdbcurl of the redshift cluster.
 * @property copyOptions Copy options for copying the data from the s3 intermediate bucket into redshift, for example to change the default delimiter. For valid values, see the [AWS documentation](http://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html)
 * @property dataTableColumns The data table columns that will be targeted by the copy command.
 * @property dataTableName The name of the table in the redshift cluster that the s3 bucket will copy to.
 * @property password The password for the username above.
 * @property processingConfiguration The data processing configuration.  More details are given below.
 * @property retryDuration The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of DurationInSeconds is 0 (zero) or if the first delivery attempt takes longer than the current value.
 * @property roleArn The arn of the role the stream assumes.
 * @property s3BackupConfiguration The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
 * @property s3BackupMode The Amazon S3 backup mode.  Valid values are `Disabled` and `Enabled`.  Default value is `Disabled`.
 * @property s3Configuration The S3 Configuration. See s3_configuration for more details.
 * @property username The username that the firehose delivery stream will assume. It is strongly recommended that the username and password provided is used exclusively for Amazon Kinesis Firehose purposes, and that the permissions for the account are restricted for Amazon Redshift INSERT permissions.
 */
public data class FirehoseDeliveryStreamRedshiftConfigurationArgs(
    public val cloudwatchLoggingOptions:
    Output<FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptionsArgs>? = null,
    public val clusterJdbcurl: Output<String>,
    public val copyOptions: Output<String>? = null,
    public val dataTableColumns: Output<String>? = null,
    public val dataTableName: Output<String>,
    public val password: Output<String>,
    public val processingConfiguration:
    Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs>? = null,
    public val retryDuration: Output<Int>? = null,
    public val roleArn: Output<String>,
    public val s3BackupConfiguration:
    Output<FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs>? = null,
    public val s3BackupMode: Output<String>? = null,
    public val s3Configuration:
    Output<FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterJdbcurl(clusterJdbcurl.applyValue({ args0 -> args0 }))
            .copyOptions(copyOptions?.applyValue({ args0 -> args0 }))
            .dataTableColumns(dataTableColumns?.applyValue({ args0 -> args0 }))
            .dataTableName(dataTableName.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retryDuration(retryDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .s3BackupConfiguration(
                s3BackupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 }))
            .s3Configuration(s3Configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamRedshiftConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamRedshiftConfigurationArgsBuilder internal constructor() {
    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptionsArgs>? = null

    private var clusterJdbcurl: Output<String>? = null

    private var copyOptions: Output<String>? = null

    private var dataTableColumns: Output<String>? = null

    private var dataTableName: Output<String>? = null

    private var password: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs>? = null

    private var retryDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var s3BackupConfiguration:
        Output<FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs>? = null

    private var s3BackupMode: Output<String>? = null

    private var s3Configuration:
        Output<FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs>? = null

    private var username: Output<String>? = null

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("afhwmlfcpnvtrpcx")
    public suspend
    fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The jdbcurl of the redshift cluster.
     */
    @JvmName("baiijwnpjrrruqaa")
    public suspend fun clusterJdbcurl(`value`: Output<String>) {
        this.clusterJdbcurl = value
    }

    /**
     * @param value Copy options for copying the data from the s3 intermediate bucket into redshift, for example to change the default delimiter. For valid values, see the [AWS documentation](http://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html)
     */
    @JvmName("fdolhrlvpamhqnti")
    public suspend fun copyOptions(`value`: Output<String>) {
        this.copyOptions = value
    }

    /**
     * @param value The data table columns that will be targeted by the copy command.
     */
    @JvmName("mekndbqybwsikcpa")
    public suspend fun dataTableColumns(`value`: Output<String>) {
        this.dataTableColumns = value
    }

    /**
     * @param value The name of the table in the redshift cluster that the s3 bucket will copy to.
     */
    @JvmName("owikegykahubecmp")
    public suspend fun dataTableName(`value`: Output<String>) {
        this.dataTableName = value
    }

    /**
     * @param value The password for the username above.
     */
    @JvmName("mvgvgtxnfdwxpugc")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The data processing configuration.  More details are given below.
     */
    @JvmName("ryoycfbmfvwiygaj")
    public suspend
    fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of DurationInSeconds is 0 (zero) or if the first delivery attempt takes longer than the current value.
     */
    @JvmName("tsjyvwycnwuuxnxm")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value The arn of the role the stream assumes.
     */
    @JvmName("dcsavvwntiihjjrv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
     */
    @JvmName("erwkvlcwsrnwsjre")
    public suspend
    fun s3BackupConfiguration(`value`: Output<FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs>) {
        this.s3BackupConfiguration = value
    }

    /**
     * @param value The Amazon S3 backup mode.  Valid values are `Disabled` and `Enabled`.  Default value is `Disabled`.
     */
    @JvmName("vfxetymgqvcpxehw")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The S3 Configuration. See s3_configuration for more details.
     */
    @JvmName("vsojtxfwckvnpvfl")
    public suspend
    fun s3Configuration(`value`: Output<FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value The username that the firehose delivery stream will assume. It is strongly recommended that the username and password provided is used exclusively for Amazon Kinesis Firehose purposes, and that the permissions for the account are restricted for Amazon Redshift INSERT permissions.
     */
    @JvmName("luolhtaycqosqyqc")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("xreoivptkkisnoes")
    public suspend
    fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("tbyvswcdtwagefpp")
    public suspend
    fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The jdbcurl of the redshift cluster.
     */
    @JvmName("tlfndxkawpqysqvq")
    public suspend fun clusterJdbcurl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterJdbcurl = mapped
    }

    /**
     * @param value Copy options for copying the data from the s3 intermediate bucket into redshift, for example to change the default delimiter. For valid values, see the [AWS documentation](http://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html)
     */
    @JvmName("adtsqsynplbvmjvc")
    public suspend fun copyOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyOptions = mapped
    }

    /**
     * @param value The data table columns that will be targeted by the copy command.
     */
    @JvmName("brrwvyanxdgmxlpf")
    public suspend fun dataTableColumns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTableColumns = mapped
    }

    /**
     * @param value The name of the table in the redshift cluster that the s3 bucket will copy to.
     */
    @JvmName("gnotcggxoakhkqvt")
    public suspend fun dataTableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTableName = mapped
    }

    /**
     * @param value The password for the username above.
     */
    @JvmName("jkicqgvyowyoppdf")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The data processing configuration.  More details are given below.
     */
    @JvmName("bssjmbkfcjnddekk")
    public suspend
    fun processingConfiguration(`value`: FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration.  More details are given below.
     */
    @JvmName("wydhjlnorocwxwci")
    public suspend
    fun processingConfiguration(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of DurationInSeconds is 0 (zero) or if the first delivery attempt takes longer than the current value.
     */
    @JvmName("pkyimwidcyiwkmjq")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    /**
     * @param value The arn of the role the stream assumes.
     */
    @JvmName("drbekrqmxqvojqaj")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
     */
    @JvmName("jqlekmiskxkcveje")
    public suspend
    fun s3BackupConfiguration(`value`: FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupConfiguration = mapped
    }

    /**
     * @param argument The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
     */
    @JvmName("neccuwomarwbowms")
    public suspend
    fun s3BackupConfiguration(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3BackupConfiguration = mapped
    }

    /**
     * @param value The Amazon S3 backup mode.  Valid values are `Disabled` and `Enabled`.  Default value is `Disabled`.
     */
    @JvmName("lvhrgpgxtmhligxn")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    /**
     * @param value The S3 Configuration. See s3_configuration for more details.
     */
    @JvmName("ropnfwoqslehatcf")
    public suspend
    fun s3Configuration(`value`: FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The S3 Configuration. See s3_configuration for more details.
     */
    @JvmName("ykolabwykmpsfnqd")
    public suspend
    fun s3Configuration(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value The username that the firehose delivery stream will assume. It is strongly recommended that the username and password provided is used exclusively for Amazon Kinesis Firehose purposes, and that the permissions for the account are restricted for Amazon Redshift INSERT permissions.
     */
    @JvmName("fpkmjtvrtvnrlfhi")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): FirehoseDeliveryStreamRedshiftConfigurationArgs =
        FirehoseDeliveryStreamRedshiftConfigurationArgs(
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            clusterJdbcurl = clusterJdbcurl ?: throw PulumiNullFieldException("clusterJdbcurl"),
            copyOptions = copyOptions,
            dataTableColumns = dataTableColumns,
            dataTableName = dataTableName ?: throw PulumiNullFieldException("dataTableName"),
            password = password ?: throw PulumiNullFieldException("password"),
            processingConfiguration = processingConfiguration,
            retryDuration = retryDuration,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            s3BackupConfiguration = s3BackupConfiguration,
            s3BackupMode = s3BackupMode,
            s3Configuration = s3Configuration ?: throw PulumiNullFieldException("s3Configuration"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
