@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Array of data processors. More details are given below
 */
public data class FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors:
    Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgsBuilder internal
constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("tpqfghobdtpaqpuo")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("tgklehioddqjnxbp")
    public suspend
    fun processors(`value`: Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("nypvdwrtagoaiimc")
    public suspend fun processors(
        vararg
        values: Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>,
    ) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("wmlqaopixrdymnrh")
    public suspend
    fun processors(values: List<Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("mnelioggoxonkhyb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("cemnukrbgbalsmqp")
    public suspend
    fun processors(`value`: List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("hilihovtcumigtqx")
    public suspend
    fun processors(argument: List<suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("hhjbxcckyobsdfuv")
    public suspend fun processors(
        vararg
        argument: suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("uikmefrkiwxykbxp")
    public suspend
    fun processors(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("xwldlclfqhrbeylh")
    public suspend fun processors(
        vararg
        values: FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
