@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property parameters Array of processor parameters. More details are given below
 * @property type The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
 */
public data class FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs(
    public val parameters:
    Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder
internal constructor() {
    private var parameters:
        Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Array of processor parameters. More details are given below
     */
    @JvmName("fbqovmrvwgcdinno")
    public suspend
    fun parameters(`value`: Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("laiadrodwbqdcixy")
    public suspend fun parameters(
        vararg
        values: Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgs>,
    ) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Array of processor parameters. More details are given below
     */
    @JvmName("rflmatnqqfhvrbal")
    public suspend
    fun parameters(values: List<Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("asocafgbdmesolph")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Array of processor parameters. More details are given below
     */
    @JvmName("snkmqamilwymiliq")
    public suspend
    fun parameters(`value`: List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("brklhurajipdtgjl")
    public suspend
    fun parameters(argument: List<suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("bwrohetsntnlnmbk")
    public suspend fun parameters(
        vararg
        argument: suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of processor parameters. More details are given below
     */
    @JvmName("ijrlhgnewcfeucwm")
    public suspend
    fun parameters(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Array of processor parameters. More details are given below
     */
    @JvmName("anrdlqbnqnqbbmcw")
    public suspend fun parameters(
        vararg
        values: FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorParameterArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("uyqcapdgjgsncrrh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs =
        FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs(
            parameters = parameters,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
