@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamServerSideEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether to enable encryption at rest. Default is `false`.
 * @property keyArn Amazon Resource Name (ARN) of the encryption key. Required when `key_type` is `CUSTOMER_MANAGED_CMK`.
 * The `extended_s3_configuration` object supports the same fields from s3_configuration as well as the following:
 * @property keyType Type of encryption key. Default is `AWS_OWNED_CMK`. Valid values are `AWS_OWNED_CMK` and `CUSTOMER_MANAGED_CMK`
 */
public data class FirehoseDeliveryStreamServerSideEncryptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val keyArn: Output<String>? = null,
    public val keyType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamServerSideEncryptionArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamServerSideEncryptionArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamServerSideEncryptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keyArn(keyArn?.applyValue({ args0 -> args0 }))
            .keyType(keyType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamServerSideEncryptionArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamServerSideEncryptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var keyArn: Output<String>? = null

    private var keyType: Output<String>? = null

    /**
     * @param value Whether to enable encryption at rest. Default is `false`.
     */
    @JvmName("icyysreutibfidmr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the encryption key. Required when `key_type` is `CUSTOMER_MANAGED_CMK`.
     * The `extended_s3_configuration` object supports the same fields from s3_configuration as well as the following:
     */
    @JvmName("ibsanpaamufjhcdh")
    public suspend fun keyArn(`value`: Output<String>) {
        this.keyArn = value
    }

    /**
     * @param value Type of encryption key. Default is `AWS_OWNED_CMK`. Valid values are `AWS_OWNED_CMK` and `CUSTOMER_MANAGED_CMK`
     */
    @JvmName("pemgnxtytqmninsf")
    public suspend fun keyType(`value`: Output<String>) {
        this.keyType = value
    }

    /**
     * @param value Whether to enable encryption at rest. Default is `false`.
     */
    @JvmName("ionjuromkulqfbhc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the encryption key. Required when `key_type` is `CUSTOMER_MANAGED_CMK`.
     * The `extended_s3_configuration` object supports the same fields from s3_configuration as well as the following:
     */
    @JvmName("tiyaaydqjowgysxh")
    public suspend fun keyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyArn = mapped
    }

    /**
     * @param value Type of encryption key. Default is `AWS_OWNED_CMK`. Valid values are `AWS_OWNED_CMK` and `CUSTOMER_MANAGED_CMK`
     */
    @JvmName("scxfyxupdirqbosa")
    public suspend fun keyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyType = mapped
    }

    internal fun build(): FirehoseDeliveryStreamServerSideEncryptionArgs =
        FirehoseDeliveryStreamServerSideEncryptionArgs(
            enabled = enabled,
            keyArn = keyArn,
            keyType = keyType,
        )
}
