@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables the logging. Defaults to `false`.
 * @property logGroupName The CloudWatch group name for logging. This value is required if `enabled` is true.
 * @property logStreamName The CloudWatch log stream name for logging. This value is required if `enabled` is true.
 */
public data class FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs(
    public val enabled: Output<Boolean>? = null,
    public val logGroupName: Output<String>? = null,
    public val logStreamName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .logStreamName(logStreamName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgsBuilder internal
constructor() {
    private var enabled: Output<Boolean>? = null

    private var logGroupName: Output<String>? = null

    private var logStreamName: Output<String>? = null

    /**
     * @param value Enables or disables the logging. Defaults to `false`.
     */
    @JvmName("kclmvupuchkkgobn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The CloudWatch group name for logging. This value is required if `enabled` is true.
     */
    @JvmName("pvlwqiogfgmqxail")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The CloudWatch log stream name for logging. This value is required if `enabled` is true.
     */
    @JvmName("ythkiycsbijxsewf")
    public suspend fun logStreamName(`value`: Output<String>) {
        this.logStreamName = value
    }

    /**
     * @param value Enables or disables the logging. Defaults to `false`.
     */
    @JvmName("qidynyarbtdmonya")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The CloudWatch group name for logging. This value is required if `enabled` is true.
     */
    @JvmName("harvhxjaockceeux")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The CloudWatch log stream name for logging. This value is required if `enabled` is true.
     */
    @JvmName("ueoluenipgfxqyeu")
    public suspend fun logStreamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreamName = mapped
    }

    internal fun build(): FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs =
        FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs(
            enabled = enabled,
            logGroupName = logGroupName,
            logStreamName = logStreamName,
        )
}
