@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Array of data processors. More details are given below
 */
public data class FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors:
    Output<List<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgsBuilder internal
constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("xgkqipkfoeplulpk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("iidfrvapeglwhjpo")
    public suspend
    fun processors(`value`: Output<List<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("fhqwcjdqkwkwdiwy")
    public suspend fun processors(
        vararg
        values: Output<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgs>,
    ) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("cuhiofybadwkexeq")
    public suspend
    fun processors(values: List<Output<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("gxwclsbbxegohfjr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("wdbipelvjnpjnxuf")
    public suspend
    fun processors(`value`: List<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("xswfisuqlnoatcip")
    public suspend
    fun processors(argument: List<suspend FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("rfmpqbcrajbsvriw")
    public suspend fun processors(
        vararg
        argument: suspend FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("yeqlsihrxjyfrnue")
    public suspend
    fun processors(argument: suspend FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("jtwhcvbsyyudxbar")
    public suspend fun processors(
        vararg
        values: FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
