@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.GetStreamConsumerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStreamConsumer.
 * @property arn ARN of the stream consumer.
 * @property name Name of the stream consumer.
 * @property streamArn ARN of the data stream the consumer is registered with.
 */
public data class GetStreamConsumerPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val streamArn: String,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.GetStreamConsumerPlainArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.GetStreamConsumerPlainArgs =
        com.pulumi.aws.kinesis.inputs.GetStreamConsumerPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .streamArn(streamArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStreamConsumerPlainArgs].
 */
@PulumiTagMarker
public class GetStreamConsumerPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var streamArn: String? = null

    /**
     * @param value ARN of the stream consumer.
     */
    @JvmName("wemhlgbmawmuemgb")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Name of the stream consumer.
     */
    @JvmName("pcuyxyplpdxxgoaw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value ARN of the data stream the consumer is registered with.
     */
    @JvmName("tyacafnvnhqcicru")
    public suspend fun streamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.streamArn = mapped
    }

    internal fun build(): GetStreamConsumerPlainArgs = GetStreamConsumerPlainArgs(
        arn = arn,
        name = name,
        streamArn = streamArn ?: throw PulumiNullFieldException("streamArn"),
    )
}
