@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.StreamStreamModeDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property streamMode Specifies the capacity mode of the stream. Must be either `PROVISIONED` or `ON_DEMAND`.
 */
public data class StreamStreamModeDetailsArgs(
    public val streamMode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.StreamStreamModeDetailsArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.StreamStreamModeDetailsArgs =
        com.pulumi.aws.kinesis.inputs.StreamStreamModeDetailsArgs.builder()
            .streamMode(streamMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamStreamModeDetailsArgs].
 */
@PulumiTagMarker
public class StreamStreamModeDetailsArgsBuilder internal constructor() {
    private var streamMode: Output<String>? = null

    /**
     * @param value Specifies the capacity mode of the stream. Must be either `PROVISIONED` or `ON_DEMAND`.
     */
    @JvmName("xqyprlxypnkvfbsi")
    public suspend fun streamMode(`value`: Output<String>) {
        this.streamMode = value
    }

    /**
     * @param value Specifies the capacity mode of the stream. Must be either `PROVISIONED` or `ON_DEMAND`.
     */
    @JvmName("idpxoqbsiemmpfdp")
    public suspend fun streamMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamMode = mapped
    }

    internal fun build(): StreamStreamModeDetailsArgs = StreamStreamModeDetailsArgs(
        streamMode = streamMode ?: throw PulumiNullFieldException("streamMode"),
    )
}
