@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property logStreamArn The ARN of the CloudWatch Log Stream.
 * @property roleArn The ARN of the IAM Role used to send application messages.
 */
public data class AnalyticsApplicationCloudwatchLoggingOptions(
    public val id: String? = null,
    public val logStreamArn: String,
    public val roleArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationCloudwatchLoggingOptions):
            AnalyticsApplicationCloudwatchLoggingOptions = AnalyticsApplicationCloudwatchLoggingOptions(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            logStreamArn = javaType.logStreamArn(),
            roleArn = javaType.roleArn(),
        )
    }
}
