@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceArn The ARN of the Kinesis Firehose delivery stream.
 * @property roleArn The ARN of the IAM Role used to access the stream.
 */
public data class AnalyticsApplicationInputsKinesisFirehose(
    public val resourceArn: String,
    public val roleArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationInputsKinesisFirehose):
            AnalyticsApplicationInputsKinesisFirehose = AnalyticsApplicationInputsKinesisFirehose(
            resourceArn = javaType.resourceArn(),
            roleArn = javaType.roleArn(),
        )
    }
}
