@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property recordColumns The Record Column mapping for the streaming source data element.
 * See Record Columns below for more details.
 * @property recordEncoding The Encoding of the record in the streaming source.
 * @property recordFormat The Record Format and mapping information to schematize a record.
 * See Record Format below for more details.
 */
public data class AnalyticsApplicationInputsSchema(
    public val recordColumns: List<AnalyticsApplicationInputsSchemaRecordColumn>,
    public val recordEncoding: String? = null,
    public val recordFormat: AnalyticsApplicationInputsSchemaRecordFormat,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationInputsSchema):
            AnalyticsApplicationInputsSchema = AnalyticsApplicationInputsSchema(
            recordColumns = javaType.recordColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsSchemaRecordColumn.Companion.toKotlin(args0)
                })
            }),
            recordEncoding = javaType.recordEncoding().map({ args0 -> args0 }).orElse(null),
            recordFormat = javaType.recordFormat().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsSchemaRecordFormat.Companion.toKotlin(args0)
            }),
        )
    }
}
