@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceArn The ARN of the Lambda function.
 * @property roleArn The ARN of the IAM Role used to access the Lambda function.
 */
public data class AnalyticsApplicationOutputLambda(
    public val resourceArn: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationOutputLambda):
            AnalyticsApplicationOutputLambda = AnalyticsApplicationOutputLambda(
            resourceArn = javaType.resourceArn(),
            roleArn = javaType.roleArn(),
        )
    }
}
