@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketArn The S3 Bucket ARN.
 * @property fileKey The File Key name containing reference data.
 * @property roleArn The ARN of the IAM Role used to send application messages.
 */
public data class AnalyticsApplicationReferenceDataSourcesS3(
    public val bucketArn: String,
    public val fileKey: String,
    public val roleArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationReferenceDataSourcesS3):
            AnalyticsApplicationReferenceDataSourcesS3 = AnalyticsApplicationReferenceDataSourcesS3(
            bucketArn = javaType.bucketArn(),
            fileKey = javaType.fileKey(),
            roleArn = javaType.roleArn(),
        )
    }
}
