@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketArn The ARN of the S3 bucket
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below
 * @property compressionFormat The compression format. If no value is specified, the default is `UNCOMPRESSED`. Other supported values are `GZIP`, `ZIP`, `Snappy`, & `HADOOP_SNAPPY`.
 * @property errorOutputPrefix Prefix added to failed records before writing them to S3. Not currently supported for `redshift` destination. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
 * @property kmsKeyArn Specifies the KMS key ARN the stream will use to encrypt data. If not set, no encryption will
 * be used.
 * @property prefix The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket
 * @property roleArn The ARN of the role used to access the Amazon MSK cluster.
 */
public data class FirehoseDeliveryStreamElasticsearchConfigurationS3Configuration(
    public val bucketArn: String,
    public val bufferingInterval: Int? = null,
    public val bufferingSize: Int? = null,
    public val cloudwatchLoggingOptions:
    FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptions? =
        null,
    public val compressionFormat: String? = null,
    public val errorOutputPrefix: String? = null,
    public val kmsKeyArn: String? = null,
    public val prefix: String? = null,
    public val roleArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamElasticsearchConfigurationS3Configuration):
            FirehoseDeliveryStreamElasticsearchConfigurationS3Configuration =
            FirehoseDeliveryStreamElasticsearchConfigurationS3Configuration(
                bucketArn = javaType.bucketArn(),
                bufferingInterval = javaType.bufferingInterval().map({ args0 -> args0 }).orElse(null),
                bufferingSize = javaType.bufferingSize().map({ args0 -> args0 }).orElse(null),
                cloudwatchLoggingOptions = javaType.cloudwatchLoggingOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptions.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                compressionFormat = javaType.compressionFormat().map({ args0 -> args0 }).orElse(null),
                errorOutputPrefix = javaType.errorOutputPrefix().map({ args0 -> args0 }).orElse(null),
                kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
                prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn(),
            )
    }
}
