@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property roleArn The ARN of the IAM role to be assumed by Firehose for calling the Amazon EC2 configuration API and for creating network interfaces. Make sure role has necessary [IAM permissions](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-es-vpc)
 * @property securityGroupIds A list of security group IDs to associate with Kinesis Firehose.
 * @property subnetIds A list of subnet IDs to associate with Kinesis Firehose.
 * @property vpcId
 */
public data class FirehoseDeliveryStreamElasticsearchConfigurationVpcConfig(
    public val roleArn: String,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfig):
            FirehoseDeliveryStreamElasticsearchConfigurationVpcConfig =
            FirehoseDeliveryStreamElasticsearchConfigurationVpcConfig(
                roleArn = javaType.roleArn(),
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
                vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
