@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Defaults to `true`. Set it to `false` if you want to disable format conversion while preserving the configuration details.
 * @property inputFormatConfiguration Nested argument that specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON. More details below.
 * @property outputFormatConfiguration Nested argument that specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format. More details below.
 * @property schemaConfiguration Nested argument that specifies the AWS Glue Data Catalog table that contains the column information. More details below.
 */
public data class FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfiguration(
    public val enabled: Boolean? = null,
    public val inputFormatConfiguration:
    FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfiguration,
    public val outputFormatConfiguration:
    FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfiguration,
    public val schemaConfiguration:
    FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfiguration):
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfiguration =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfiguration(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                inputFormatConfiguration = javaType.inputFormatConfiguration().let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfiguration.Companion.toKotlin(args0)
                }),
                outputFormatConfiguration = javaType.outputFormatConfiguration().let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfiguration.Companion.toKotlin(args0)
                }),
                schemaConfiguration = javaType.schemaConfiguration().let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration.Companion.toKotlin(args0)
                }),
            )
    }
}
