@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property caseInsensitive When set to true, which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
 * @property columnToJsonKeyMappings A map of column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, timestamp is a Hive keyword. If you have a JSON key named timestamp, set this parameter to `{ ts = "timestamp" }` to map this key to a column named ts.
 * @property convertDotsInJsonKeysToUnderscores When set to `true`, specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option. Defaults to `false`.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDe(
    public val caseInsensitive: Boolean? = null,
    public val columnToJsonKeyMappings: Map<String, String>? = null,
    public val convertDotsInJsonKeysToUnderscores: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDe):
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDe =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDe(
                caseInsensitive = javaType.caseInsensitive().map({ args0 -> args0 }).orElse(null),
                columnToJsonKeyMappings = javaType.columnToJsonKeyMappings().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                convertDotsInJsonKeysToUnderscores = javaType.convertDotsInJsonKeysToUnderscores().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
