@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property blockSizeBytes The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
 * @property bloomFilterColumns A list of column names for which you want Kinesis Data Firehose to create bloom filters.
 * @property bloomFilterFalsePositiveProbability The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is `0.05`, the minimum is `0`, and the maximum is `1`.
 * @property compression The compression code to use over data blocks. The default is `SNAPPY`.
 * @property dictionaryKeyThreshold A float that represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to `1`.
 * @property enablePadding Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false`.
 * @property formatVersion The version of the file to write. The possible values are `V0_11` and `V0_12`. The default is `V0_12`.
 * @property paddingTolerance A float between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is `0.05`, which means 5 percent of stripe size. For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task. Kinesis Data Firehose ignores this parameter when `enable_padding` is `false`.
 * @property rowIndexStride The number of rows between index entries. The default is `10000` and the minimum is `1000`.
 * @property stripeSizeBytes The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDe(
    public val blockSizeBytes: Int? = null,
    public val bloomFilterColumns: List<String>? = null,
    public val bloomFilterFalsePositiveProbability: Double? = null,
    public val compression: String? = null,
    public val dictionaryKeyThreshold: Double? = null,
    public val enablePadding: Boolean? = null,
    public val formatVersion: String? = null,
    public val paddingTolerance: Double? = null,
    public val rowIndexStride: Int? = null,
    public val stripeSizeBytes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDe):
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDe =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDe(
                blockSizeBytes = javaType.blockSizeBytes().map({ args0 -> args0 }).orElse(null),
                bloomFilterColumns = javaType.bloomFilterColumns().map({ args0 -> args0 }),
                bloomFilterFalsePositiveProbability = javaType.bloomFilterFalsePositiveProbability().map({ args0 ->
                    args0
                }).orElse(null),
                compression = javaType.compression().map({ args0 -> args0 }).orElse(null),
                dictionaryKeyThreshold = javaType.dictionaryKeyThreshold().map({ args0 -> args0 }).orElse(null),
                enablePadding = javaType.enablePadding().map({ args0 -> args0 }).orElse(null),
                formatVersion = javaType.formatVersion().map({ args0 -> args0 }).orElse(null),
                paddingTolerance = javaType.paddingTolerance().map({ args0 -> args0 }).orElse(null),
                rowIndexStride = javaType.rowIndexStride().map({ args0 -> args0 }).orElse(null),
                stripeSizeBytes = javaType.stripeSizeBytes().map({ args0 -> args0 }).orElse(null),
            )
    }
}
