@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property blockSizeBytes The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
 * @property compression The compression code to use over data blocks. The possible values are `UNCOMPRESSED`, `SNAPPY`, and `GZIP`, with the default being `SNAPPY`. Use `SNAPPY` for higher decompression speed. Use `GZIP` if the compression ratio is more important than speed.
 * @property enableDictionaryCompression Indicates whether to enable dictionary compression.
 * @property maxPaddingBytes The maximum amount of padding to apply. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `0`.
 * @property pageSizeBytes The Parquet page size. Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
 * @property writerVersion Indicates the version of row format to output. The possible values are `V1` and `V2`. The default is `V1`.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDe(
    public val blockSizeBytes: Int? = null,
    public val compression: String? = null,
    public val enableDictionaryCompression: Boolean? = null,
    public val maxPaddingBytes: Int? = null,
    public val pageSizeBytes: Int? = null,
    public val writerVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDe):
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDe =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDe(
                blockSizeBytes = javaType.blockSizeBytes().map({ args0 -> args0 }).orElse(null),
                compression = javaType.compression().map({ args0 -> args0 }).orElse(null),
                enableDictionaryCompression = javaType.enableDictionaryCompression().map({ args0 ->
                    args0
                }).orElse(null),
                maxPaddingBytes = javaType.maxPaddingBytes().map({ args0 -> args0 }).orElse(null),
                pageSizeBytes = javaType.pageSizeBytes().map({ args0 -> args0 }).orElse(null),
                writerVersion = javaType.writerVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
