@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kinesisStreamArn The kinesis stream used as the source of the firehose delivery stream.
 * @property roleArn The ARN of the role that provides access to the source Kinesis stream.
 */
public data class FirehoseDeliveryStreamKinesisSourceConfiguration(
    public val kinesisStreamArn: String,
    public val roleArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamKinesisSourceConfiguration):
            FirehoseDeliveryStreamKinesisSourceConfiguration =
            FirehoseDeliveryStreamKinesisSourceConfiguration(
                kinesisStreamArn = javaType.kinesisStreamArn(),
                roleArn = javaType.roleArn(),
            )
    }
}
