@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below
 * @property collectionEndpoint The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
 * @property indexName The Serverless offering for Amazon OpenSearch Service index name.
 * @property processingConfiguration The data processing configuration.  More details are given below.
 * @property retryDuration After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time, in seconds between 0 to 7200, during which Kinesis Data Firehose retries delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.  The pattern needs to be `arn:.*`.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
 * @property s3Configuration The S3 Configuration. See s3_configuration for more details.
 * @property vpcConfig The VPC configuration for the delivery stream to connect to OpenSearch Serverless associated with the VPC. More details are given below
 */
public data class FirehoseDeliveryStreamOpensearchserverlessConfiguration(
    public val bufferingInterval: Int? = null,
    public val bufferingSize: Int? = null,
    public val cloudwatchLoggingOptions:
    FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptions? = null,
    public val collectionEndpoint: String,
    public val indexName: String,
    public val processingConfiguration:
    FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfiguration? = null,
    public val retryDuration: Int? = null,
    public val roleArn: String,
    public val s3BackupMode: String? = null,
    public val s3Configuration:
    FirehoseDeliveryStreamOpensearchserverlessConfigurationS3Configuration,
    public val vpcConfig: FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamOpensearchserverlessConfiguration):
            FirehoseDeliveryStreamOpensearchserverlessConfiguration =
            FirehoseDeliveryStreamOpensearchserverlessConfiguration(
                bufferingInterval = javaType.bufferingInterval().map({ args0 -> args0 }).orElse(null),
                bufferingSize = javaType.bufferingSize().map({ args0 -> args0 }).orElse(null),
                cloudwatchLoggingOptions = javaType.cloudwatchLoggingOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptions.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                collectionEndpoint = javaType.collectionEndpoint(),
                indexName = javaType.indexName(),
                processingConfiguration = javaType.processingConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                retryDuration = javaType.retryDuration().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn(),
                s3BackupMode = javaType.s3BackupMode().map({ args0 -> args0 }).orElse(null),
                s3Configuration = javaType.s3Configuration().let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationS3Configuration.Companion.toKotlin(args0)
                }),
                vpcConfig = javaType.vpcConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
