@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether to enable encryption at rest. Default is `false`.
 * @property keyArn Amazon Resource Name (ARN) of the encryption key. Required when `key_type` is `CUSTOMER_MANAGED_CMK`.
 * The `extended_s3_configuration` object supports the same fields from s3_configuration as well as the following:
 * @property keyType Type of encryption key. Default is `AWS_OWNED_CMK`. Valid values are `AWS_OWNED_CMK` and `CUSTOMER_MANAGED_CMK`
 */
public data class FirehoseDeliveryStreamServerSideEncryption(
    public val enabled: Boolean? = null,
    public val keyArn: String? = null,
    public val keyType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamServerSideEncryption):
            FirehoseDeliveryStreamServerSideEncryption = FirehoseDeliveryStreamServerSideEncryption(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            keyArn = javaType.keyArn().map({ args0 -> args0 }).orElse(null),
            keyType = javaType.keyType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
