@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below.
 * @property hecAcknowledgmentTimeout The amount of time, in seconds between 180 and 600, that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it data.
 * @property hecEndpoint The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
 * @property hecEndpointType The HEC endpoint type. Valid values are `Raw` or `Event`. The default value is `Raw`.
 * @property hecToken The GUID that you obtain from your Splunk cluster when you create a new HEC endpoint.
 * @property processingConfiguration The data processing configuration.  More details are given below.
 * @property retryDuration After an initial failure to deliver to Splunk, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedEventsOnly` and `AllEvents`.  Default value is `FailedEventsOnly`.
 * @property s3Configuration The S3 Configuration. See s3_configuration for more details.
 */
public data class FirehoseDeliveryStreamSplunkConfiguration(
    public val cloudwatchLoggingOptions:
    FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptions? = null,
    public val hecAcknowledgmentTimeout: Int? = null,
    public val hecEndpoint: String,
    public val hecEndpointType: String? = null,
    public val hecToken: String,
    public val processingConfiguration:
    FirehoseDeliveryStreamSplunkConfigurationProcessingConfiguration? = null,
    public val retryDuration: Int? = null,
    public val s3BackupMode: String? = null,
    public val s3Configuration: FirehoseDeliveryStreamSplunkConfigurationS3Configuration,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamSplunkConfiguration):
            FirehoseDeliveryStreamSplunkConfiguration = FirehoseDeliveryStreamSplunkConfiguration(
            cloudwatchLoggingOptions = javaType.cloudwatchLoggingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hecAcknowledgmentTimeout = javaType.hecAcknowledgmentTimeout().map({ args0 -> args0 }).orElse(null),
            hecEndpoint = javaType.hecEndpoint(),
            hecEndpointType = javaType.hecEndpointType().map({ args0 -> args0 }).orElse(null),
            hecToken = javaType.hecToken(),
            processingConfiguration = javaType.processingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retryDuration = javaType.retryDuration().map({ args0 -> args0 }).orElse(null),
            s3BackupMode = javaType.s3BackupMode().map({ args0 -> args0 }).orElse(null),
            s3Configuration = javaType.s3Configuration().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationS3Configuration.Companion.toKotlin(args0)
            }),
        )
    }
}
