@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin

import com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfiguration
import com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationCloudwatchLoggingOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfiguration.Companion.toKotlin as applicationApplicationConfigurationToKotlin
import com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationCloudwatchLoggingOptions.Companion.toKotlin as applicationCloudwatchLoggingOptionsToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.aws.kinesisanalyticsv2.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Manages a Kinesis Analytics v2 Application.
 * This resource can be used to manage both Kinesis Data Analytics for SQL applications and Kinesis Data Analytics for Apache Flink applications.
 * > **Note:** Kinesis Data Analytics for SQL applications created using this resource cannot currently be viewed in the AWS Console. To manage Kinesis Data Analytics for SQL applications that can also be viewed in the AWS Console, use the `aws.kinesis.AnalyticsApplication` resource.
 * ## Example Usage
 * ### Apache Flink Application
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.kinesisanalyticsv2.Application;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-flink-application")
 *             .source(new FileAsset("flink-app.jar"))
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .runtimeEnvironment("FLINK-1_8")
 *             .serviceExecutionRole(aws_iam_role.example().arn())
 *             .applicationConfiguration(ApplicationApplicationConfigurationArgs.builder()
 *                 .applicationCodeConfiguration(ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder()
 *                     .codeContent(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder()
 *                         .s3ContentLocation(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs.builder()
 *                             .bucketArn(exampleBucketV2.arn())
 *                             .fileKey(exampleBucketObjectv2.key())
 *                             .build())
 *                         .build())
 *                     .codeContentType("ZIPFILE")
 *                     .build())
 *                 .environmentProperties(ApplicationApplicationConfigurationEnvironmentPropertiesArgs.builder()
 *                     .propertyGroups(
 *                         ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs.builder()
 *                             .propertyGroupId("PROPERTY-GROUP-1")
 *                             .propertyMap(Map.of("Key1", "Value1"))
 *                             .build(),
 *                         ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs.builder()
 *                             .propertyGroupId("PROPERTY-GROUP-2")
 *                             .propertyMap(Map.ofEntries(
 *                                 Map.entry("KeyA", "ValueA"),
 *                                 Map.entry("KeyB", "ValueB")
 *                             ))
 *                             .build())
 *                     .build())
 *                 .flinkApplicationConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs.builder()
 *                     .checkpointConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs.builder()
 *                         .configurationType("DEFAULT")
 *                         .build())
 *                     .monitoringConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs.builder()
 *                         .configurationType("CUSTOM")
 *                         .logLevel("DEBUG")
 *                         .metricsLevel("TASK")
 *                         .build())
 *                     .parallelismConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs.builder()
 *                         .autoScalingEnabled(true)
 *                         .configurationType("CUSTOM")
 *                         .parallelism(10)
 *                         .parallelismPerKpu(4)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ### SQL Application
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogStream;
 * import com.pulumi.aws.cloudwatch.LogStreamArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.Application;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationCloudwatchLoggingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleLogStream = new LogStream("exampleLogStream", LogStreamArgs.builder()
 *             .logGroupName(exampleLogGroup.name())
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .runtimeEnvironment("SQL-1_0")
 *             .serviceExecutionRole(aws_iam_role.example().arn())
 *             .applicationConfiguration(ApplicationApplicationConfigurationArgs.builder()
 *                 .applicationCodeConfiguration(ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder()
 *                     .codeContent(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder()
 *                         .textContent("""
 * SELECT 1;
 *                         """)
 *                         .build())
 *                     .codeContentType("PLAINTEXT")
 *                     .build())
 *                 .sqlApplicationConfiguration(ApplicationApplicationConfigurationSqlApplicationConfigurationArgs.builder()
 *                     .input(ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs.builder()
 *                         .namePrefix("PREFIX_1")
 *                         .inputParallelism(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs.builder()
 *                             .count(3)
 *                             .build())
 *                         .inputSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs.builder()
 *                             .recordColumns(
 *                                 ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs.builder()
 *                                     .name("COLUMN_1")
 *                                     .sqlType("VARCHAR(8)")
 *                                     .mapping("MAPPING-1")
 *                                     .build(),
 *                                 ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs.builder()
 *                                     .name("COLUMN_2")
 *                                     .sqlType("DOUBLE")
 *                                     .build())
 *                             .recordEncoding("UTF-8")
 *                             .recordFormat(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs.builder()
 *                                 .recordFormatType("CSV")
 *                                 .mappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs.builder()
 *                                     .csvMappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs.builder()
 *                                         .recordColumnDelimiter(",")
 *                                         .recordRowDelimiter("""
 *                                         """)
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .kinesisStreamsInput(ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs.builder()
 *                             .resourceArn(aws_kinesis_stream.example().arn())
 *                             .build())
 *                         .build())
 *                     .outputs(
 *                         ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs.builder()
 *                             .name("OUTPUT_1")
 *                             .destinationSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputDestinationSchemaArgs.builder()
 *                                 .recordFormatType("JSON")
 *                                 .build())
 *                             .lambdaOutput(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputLambdaOutputArgs.builder()
 *                                 .resourceArn(aws_lambda_function.example().arn())
 *                                 .build())
 *                             .build(),
 *                         ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs.builder()
 *                             .name("OUTPUT_2")
 *                             .destinationSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputDestinationSchemaArgs.builder()
 *                                 .recordFormatType("CSV")
 *                                 .build())
 *                             .kinesisFirehoseOutput(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputKinesisFirehoseOutputArgs.builder()
 *                                 .resourceArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                                 .build())
 *                             .build())
 *                     .referenceDataSource(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs.builder()
 *                         .tableName("TABLE-1")
 *                         .referenceSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs.builder()
 *                             .recordColumns(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs.builder()
 *                                 .name("COLUMN_1")
 *                                 .sqlType("INTEGER")
 *                                 .build())
 *                             .recordFormat(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs.builder()
 *                                 .recordFormatType("JSON")
 *                                 .mappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs.builder()
 *                                     .jsonMappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs.builder()
 *                                         .recordRowPath("$")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .s3ReferenceDataSource(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs.builder()
 *                             .bucketArn(aws_s3_bucket.example().arn())
 *                             .fileKey("KEY-1")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .cloudwatchLoggingOptions(ApplicationCloudwatchLoggingOptionsArgs.builder()
 *                 .logStreamArn(exampleLogStream.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### VPC Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.kinesisanalyticsv2.Application;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationVpcConfigurationArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-flink-application")
 *             .source(new FileAsset("flink-app.jar"))
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .runtimeEnvironment("FLINK-1_8")
 *             .serviceExecutionRole(aws_iam_role.example().arn())
 *             .applicationConfiguration(ApplicationApplicationConfigurationArgs.builder()
 *                 .applicationCodeConfiguration(ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder()
 *                     .codeContent(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder()
 *                         .s3ContentLocation(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs.builder()
 *                             .bucketArn(exampleBucketV2.arn())
 *                             .fileKey(exampleBucketObjectv2.key())
 *                             .build())
 *                         .build())
 *                     .codeContentType("ZIPFILE")
 *                     .build())
 *                 .vpcConfiguration(ApplicationApplicationConfigurationVpcConfigurationArgs.builder()
 *                     .securityGroupIds(
 *                         aws_security_group.example()[0].id(),
 *                         aws_security_group.example()[1].id())
 *                     .subnetIds(aws_subnet.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_kinesisanalyticsv2_application` using the application ARN. For example:
 * ```sh
 *  $ pulumi import aws:kinesisanalyticsv2/application:Application example arn:aws:kinesisanalytics:us-west-2:123456789012:application/example-sql-application
 * ```
 *
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.aws.kinesisanalyticsv2.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * The application's configuration
     */
    public val applicationConfiguration: Output<ApplicationApplicationConfiguration>
        get() = javaResource.applicationConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationApplicationConfigurationToKotlin(args0)
            })
        })

    /**
     * The ARN of the application.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A CloudWatch log stream to monitor application configuration errors.
     */
    public val cloudwatchLoggingOptions: Output<ApplicationCloudwatchLoggingOptions>?
        get() = javaResource.cloudwatchLoggingOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationCloudwatchLoggingOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The current timestamp when the application was created.
     */
    public val createTimestamp: Output<String>
        get() = javaResource.createTimestamp().applyValue({ args0 -> args0 })

    /**
     * A summary description of the application.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to force stop an unresponsive Flink-based application.
     */
    public val forceStop: Output<Boolean>?
        get() = javaResource.forceStop().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The current timestamp when the application was last updated.
     */
    public val lastUpdateTimestamp: Output<String>
        get() = javaResource.lastUpdateTimestamp().applyValue({ args0 -> args0 })

    /**
     * The name of the application.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The runtime environment for the application. Valid values: `SQL-1_0`, `FLINK-1_6`, `FLINK-1_8`, `FLINK-1_11`, `FLINK-1_13`, `FLINK-1_15`.
     */
    public val runtimeEnvironment: Output<String>
        get() = javaResource.runtimeEnvironment().applyValue({ args0 -> args0 })

    /**
     * The ARN of the IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery streams, Amazon S3 objects, and other external resources.
     */
    public val serviceExecutionRole: Output<String>
        get() = javaResource.serviceExecutionRole().applyValue({ args0 -> args0 })

    /**
     * Whether to start or stop the application.
     */
    public val startApplication: Output<Boolean>?
        get() = javaResource.startApplication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the application.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The current application version. Kinesis Data Analytics updates the `version_id` each time the application is updated.
     */
    public val versionId: Output<Int>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesisanalyticsv2.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.aws.kinesisanalyticsv2.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit):
    Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
