@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin

import com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs.builder
import com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs.ApplicationApplicationConfigurationArgs
import com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs.ApplicationApplicationConfigurationArgsBuilder
import com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs.ApplicationCloudwatchLoggingOptionsArgs
import com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs.ApplicationCloudwatchLoggingOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Kinesis Analytics v2 Application.
 * This resource can be used to manage both Kinesis Data Analytics for SQL applications and Kinesis Data Analytics for Apache Flink applications.
 * > **Note:** Kinesis Data Analytics for SQL applications created using this resource cannot currently be viewed in the AWS Console. To manage Kinesis Data Analytics for SQL applications that can also be viewed in the AWS Console, use the `aws.kinesis.AnalyticsApplication` resource.
 * ## Example Usage
 * ### Apache Flink Application
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.kinesisanalyticsv2.Application;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-flink-application")
 *             .source(new FileAsset("flink-app.jar"))
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .runtimeEnvironment("FLINK-1_8")
 *             .serviceExecutionRole(aws_iam_role.example().arn())
 *             .applicationConfiguration(ApplicationApplicationConfigurationArgs.builder()
 *                 .applicationCodeConfiguration(ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder()
 *                     .codeContent(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder()
 *                         .s3ContentLocation(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs.builder()
 *                             .bucketArn(exampleBucketV2.arn())
 *                             .fileKey(exampleBucketObjectv2.key())
 *                             .build())
 *                         .build())
 *                     .codeContentType("ZIPFILE")
 *                     .build())
 *                 .environmentProperties(ApplicationApplicationConfigurationEnvironmentPropertiesArgs.builder()
 *                     .propertyGroups(
 *                         ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs.builder()
 *                             .propertyGroupId("PROPERTY-GROUP-1")
 *                             .propertyMap(Map.of("Key1", "Value1"))
 *                             .build(),
 *                         ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs.builder()
 *                             .propertyGroupId("PROPERTY-GROUP-2")
 *                             .propertyMap(Map.ofEntries(
 *                                 Map.entry("KeyA", "ValueA"),
 *                                 Map.entry("KeyB", "ValueB")
 *                             ))
 *                             .build())
 *                     .build())
 *                 .flinkApplicationConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs.builder()
 *                     .checkpointConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs.builder()
 *                         .configurationType("DEFAULT")
 *                         .build())
 *                     .monitoringConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs.builder()
 *                         .configurationType("CUSTOM")
 *                         .logLevel("DEBUG")
 *                         .metricsLevel("TASK")
 *                         .build())
 *                     .parallelismConfiguration(ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs.builder()
 *                         .autoScalingEnabled(true)
 *                         .configurationType("CUSTOM")
 *                         .parallelism(10)
 *                         .parallelismPerKpu(4)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ### SQL Application
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogStream;
 * import com.pulumi.aws.cloudwatch.LogStreamArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.Application;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationCloudwatchLoggingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleLogStream = new LogStream("exampleLogStream", LogStreamArgs.builder()
 *             .logGroupName(exampleLogGroup.name())
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .runtimeEnvironment("SQL-1_0")
 *             .serviceExecutionRole(aws_iam_role.example().arn())
 *             .applicationConfiguration(ApplicationApplicationConfigurationArgs.builder()
 *                 .applicationCodeConfiguration(ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder()
 *                     .codeContent(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder()
 *                         .textContent("""
 * SELECT 1;
 *                         """)
 *                         .build())
 *                     .codeContentType("PLAINTEXT")
 *                     .build())
 *                 .sqlApplicationConfiguration(ApplicationApplicationConfigurationSqlApplicationConfigurationArgs.builder()
 *                     .input(ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs.builder()
 *                         .namePrefix("PREFIX_1")
 *                         .inputParallelism(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs.builder()
 *                             .count(3)
 *                             .build())
 *                         .inputSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs.builder()
 *                             .recordColumns(
 *                                 ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs.builder()
 *                                     .name("COLUMN_1")
 *                                     .sqlType("VARCHAR(8)")
 *                                     .mapping("MAPPING-1")
 *                                     .build(),
 *                                 ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs.builder()
 *                                     .name("COLUMN_2")
 *                                     .sqlType("DOUBLE")
 *                                     .build())
 *                             .recordEncoding("UTF-8")
 *                             .recordFormat(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs.builder()
 *                                 .recordFormatType("CSV")
 *                                 .mappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs.builder()
 *                                     .csvMappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs.builder()
 *                                         .recordColumnDelimiter(",")
 *                                         .recordRowDelimiter("""
 *                                         """)
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .kinesisStreamsInput(ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs.builder()
 *                             .resourceArn(aws_kinesis_stream.example().arn())
 *                             .build())
 *                         .build())
 *                     .outputs(
 *                         ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs.builder()
 *                             .name("OUTPUT_1")
 *                             .destinationSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputDestinationSchemaArgs.builder()
 *                                 .recordFormatType("JSON")
 *                                 .build())
 *                             .lambdaOutput(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputLambdaOutputArgs.builder()
 *                                 .resourceArn(aws_lambda_function.example().arn())
 *                                 .build())
 *                             .build(),
 *                         ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs.builder()
 *                             .name("OUTPUT_2")
 *                             .destinationSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputDestinationSchemaArgs.builder()
 *                                 .recordFormatType("CSV")
 *                                 .build())
 *                             .kinesisFirehoseOutput(ApplicationApplicationConfigurationSqlApplicationConfigurationOutputKinesisFirehoseOutputArgs.builder()
 *                                 .resourceArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                                 .build())
 *                             .build())
 *                     .referenceDataSource(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs.builder()
 *                         .tableName("TABLE-1")
 *                         .referenceSchema(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs.builder()
 *                             .recordColumns(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs.builder()
 *                                 .name("COLUMN_1")
 *                                 .sqlType("INTEGER")
 *                                 .build())
 *                             .recordFormat(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs.builder()
 *                                 .recordFormatType("JSON")
 *                                 .mappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs.builder()
 *                                     .jsonMappingParameters(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs.builder()
 *                                         .recordRowPath("$")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .s3ReferenceDataSource(ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs.builder()
 *                             .bucketArn(aws_s3_bucket.example().arn())
 *                             .fileKey("KEY-1")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .cloudwatchLoggingOptions(ApplicationCloudwatchLoggingOptionsArgs.builder()
 *                 .logStreamArn(exampleLogStream.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### VPC Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.kinesisanalyticsv2.Application;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs;
 * import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationVpcConfigurationArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-flink-application")
 *             .source(new FileAsset("flink-app.jar"))
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .runtimeEnvironment("FLINK-1_8")
 *             .serviceExecutionRole(aws_iam_role.example().arn())
 *             .applicationConfiguration(ApplicationApplicationConfigurationArgs.builder()
 *                 .applicationCodeConfiguration(ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder()
 *                     .codeContent(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder()
 *                         .s3ContentLocation(ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs.builder()
 *                             .bucketArn(exampleBucketV2.arn())
 *                             .fileKey(exampleBucketObjectv2.key())
 *                             .build())
 *                         .build())
 *                     .codeContentType("ZIPFILE")
 *                     .build())
 *                 .vpcConfiguration(ApplicationApplicationConfigurationVpcConfigurationArgs.builder()
 *                     .securityGroupIds(
 *                         aws_security_group.example()[0].id(),
 *                         aws_security_group.example()[1].id())
 *                     .subnetIds(aws_subnet.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_kinesisanalyticsv2_application` using the application ARN. For example:
 * ```sh
 *  $ pulumi import aws:kinesisanalyticsv2/application:Application example arn:aws:kinesisanalytics:us-west-2:123456789012:application/example-sql-application
 * ```
 * @property applicationConfiguration The application's configuration
 * @property cloudwatchLoggingOptions A CloudWatch log stream to monitor application configuration errors.
 * @property description A summary description of the application.
 * @property forceStop Whether to force stop an unresponsive Flink-based application.
 * @property name The name of the application.
 * @property runtimeEnvironment The runtime environment for the application. Valid values: `SQL-1_0`, `FLINK-1_6`, `FLINK-1_8`, `FLINK-1_11`, `FLINK-1_13`, `FLINK-1_15`.
 * @property serviceExecutionRole The ARN of the IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery streams, Amazon S3 objects, and other external resources.
 * @property startApplication Whether to start or stop the application.
 * @property tags A map of tags to assign to the application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class ApplicationArgs(
    public val applicationConfiguration: Output<ApplicationApplicationConfigurationArgs>? = null,
    public val cloudwatchLoggingOptions: Output<ApplicationCloudwatchLoggingOptionsArgs>? = null,
    public val description: Output<String>? = null,
    public val forceStop: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val runtimeEnvironment: Output<String>? = null,
    public val serviceExecutionRole: Output<String>? = null,
    public val startApplication: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs =
        com.pulumi.aws.kinesisanalyticsv2.ApplicationArgs.builder()
            .applicationConfiguration(
                applicationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .forceStop(forceStop?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .runtimeEnvironment(runtimeEnvironment?.applyValue({ args0 -> args0 }))
            .serviceExecutionRole(serviceExecutionRole?.applyValue({ args0 -> args0 }))
            .startApplication(startApplication?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationConfiguration: Output<ApplicationApplicationConfigurationArgs>? = null

    private var cloudwatchLoggingOptions: Output<ApplicationCloudwatchLoggingOptionsArgs>? = null

    private var description: Output<String>? = null

    private var forceStop: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var runtimeEnvironment: Output<String>? = null

    private var serviceExecutionRole: Output<String>? = null

    private var startApplication: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The application's configuration
     */
    @JvmName("oofttyxndjgghxtk")
    public suspend
    fun applicationConfiguration(`value`: Output<ApplicationApplicationConfigurationArgs>) {
        this.applicationConfiguration = value
    }

    /**
     * @param value A CloudWatch log stream to monitor application configuration errors.
     */
    @JvmName("mksaygkkniljownb")
    public suspend
    fun cloudwatchLoggingOptions(`value`: Output<ApplicationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value A summary description of the application.
     */
    @JvmName("wqkplqgeacqefsjb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to force stop an unresponsive Flink-based application.
     */
    @JvmName("xfjgoarpydbnjcsy")
    public suspend fun forceStop(`value`: Output<Boolean>) {
        this.forceStop = value
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("xqecsebvehlowvcf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The runtime environment for the application. Valid values: `SQL-1_0`, `FLINK-1_6`, `FLINK-1_8`, `FLINK-1_11`, `FLINK-1_13`, `FLINK-1_15`.
     */
    @JvmName("wcvxepjdvumxmmfo")
    public suspend fun runtimeEnvironment(`value`: Output<String>) {
        this.runtimeEnvironment = value
    }

    /**
     * @param value The ARN of the IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery streams, Amazon S3 objects, and other external resources.
     */
    @JvmName("bacxhhktdxdkmslo")
    public suspend fun serviceExecutionRole(`value`: Output<String>) {
        this.serviceExecutionRole = value
    }

    /**
     * @param value Whether to start or stop the application.
     */
    @JvmName("jqijfqutlpmovcnf")
    public suspend fun startApplication(`value`: Output<Boolean>) {
        this.startApplication = value
    }

    /**
     * @param value A map of tags to assign to the application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("qvkclomnoljeovos")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The application's configuration
     */
    @JvmName("qrewgmeeaqfovdov")
    public suspend fun applicationConfiguration(`value`: ApplicationApplicationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationConfiguration = mapped
    }

    /**
     * @param argument The application's configuration
     */
    @JvmName("knkgeeymukytabrg")
    public suspend
    fun applicationConfiguration(argument: suspend ApplicationApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationApplicationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.applicationConfiguration = mapped
    }

    /**
     * @param value A CloudWatch log stream to monitor application configuration errors.
     */
    @JvmName("ukoomlfkulkpyhfw")
    public suspend fun cloudwatchLoggingOptions(`value`: ApplicationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument A CloudWatch log stream to monitor application configuration errors.
     */
    @JvmName("kgqqxmaptghrbrjp")
    public suspend
    fun cloudwatchLoggingOptions(argument: suspend ApplicationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value A summary description of the application.
     */
    @JvmName("bjykhtxcaieminpx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to force stop an unresponsive Flink-based application.
     */
    @JvmName("birpocbprymptrfp")
    public suspend fun forceStop(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceStop = mapped
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("edoedxsajajgqapp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The runtime environment for the application. Valid values: `SQL-1_0`, `FLINK-1_6`, `FLINK-1_8`, `FLINK-1_11`, `FLINK-1_13`, `FLINK-1_15`.
     */
    @JvmName("spxnofuhevdwmgic")
    public suspend fun runtimeEnvironment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeEnvironment = mapped
    }

    /**
     * @param value The ARN of the IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery streams, Amazon S3 objects, and other external resources.
     */
    @JvmName("wkcjrkyshhpfmypm")
    public suspend fun serviceExecutionRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceExecutionRole = mapped
    }

    /**
     * @param value Whether to start or stop the application.
     */
    @JvmName("foblluvphllinxbl")
    public suspend fun startApplication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startApplication = mapped
    }

    /**
     * @param value A map of tags to assign to the application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("uvjdhbcvrcjluwmr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("ngyvhypqdsmoypae")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationConfiguration = applicationConfiguration,
        cloudwatchLoggingOptions = cloudwatchLoggingOptions,
        description = description,
        forceStop = forceStop,
        name = name,
        runtimeEnvironment = runtimeEnvironment,
        serviceExecutionRole = serviceExecutionRole,
        startApplication = startApplication,
        tags = tags,
    )
}
