@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApplicationSnapshot].
 */
@PulumiTagMarker
public class ApplicationSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationSnapshotArgs = ApplicationSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationSnapshotArgsBuilder.() -> Unit) {
        val builder = ApplicationSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApplicationSnapshot {
        val builtJavaResource =
            com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationSnapshot(builtJavaResource)
    }
}

/**
 * Manages a Kinesis Analytics v2 Application Snapshot.
 * Snapshots are the AWS implementation of [Flink Savepoints](https://ci.apache.org/projects/flink/flink-docs-release-1.11/ops/state/savepoints.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshot;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationSnapshot("example", ApplicationSnapshotArgs.builder()
 *             .applicationName(aws_kinesisanalyticsv2_application.example().name())
 *             .snapshotName("example-snapshot")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_kinesisanalyticsv2_application` using `application_name` together with `snapshot_name`. For example:
 * ```sh
 *  $ pulumi import aws:kinesisanalyticsv2/applicationSnapshot:ApplicationSnapshot example example-application/example-snapshot
 * ```
 *
 */
public class ApplicationSnapshot internal constructor(
    override val javaResource: com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshot,
) : KotlinCustomResource(javaResource, ApplicationSnapshotMapper) {
    /**
     * The name of an existing  Kinesis Analytics v2 Application. Note that the application must be running for a snapshot to be created.
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * The current application version ID when the snapshot was created.
     */
    public val applicationVersionId: Output<Int>
        get() = javaResource.applicationVersionId().applyValue({ args0 -> args0 })

    /**
     * The timestamp of the application snapshot.
     */
    public val snapshotCreationTimestamp: Output<String>
        get() = javaResource.snapshotCreationTimestamp().applyValue({ args0 -> args0 })

    /**
     * The name of the application snapshot.
     */
    public val snapshotName: Output<String>
        get() = javaResource.snapshotName().applyValue({ args0 -> args0 })
}

public object ApplicationSnapshotMapper : ResourceMapper<ApplicationSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationSnapshot = ApplicationSnapshot(
        javaResource
            as com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshot,
    )
}

/**
 * @see [ApplicationSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationSnapshot].
 */
public suspend fun applicationSnapshot(
    name: String,
    block: suspend ApplicationSnapshotResourceBuilder.() -> Unit,
): ApplicationSnapshot {
    val builder = ApplicationSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationSnapshot(name: String): ApplicationSnapshot {
    val builder = ApplicationSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
