@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3ContentLocation Information about the Amazon S3 bucket containing the application code.
 * @property textContent The text-format code for the application.
 * The `s3_content_location` object supports the following:
 */
public data class ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs(
    public val s3ContentLocation:
    Output<ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs>? =
        null,
    public val textContent: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs.builder()
            .s3ContentLocation(s3ContentLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textContent(textContent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgsBuilder
internal constructor() {
    private var s3ContentLocation:
        Output<ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs>? =
        null

    private var textContent: Output<String>? = null

    /**
     * @param value Information about the Amazon S3 bucket containing the application code.
     */
    @JvmName("ojuxhsuckyxgwlgp")
    public suspend
    fun s3ContentLocation(`value`: Output<ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs>) {
        this.s3ContentLocation = value
    }

    /**
     * @param value The text-format code for the application.
     * The `s3_content_location` object supports the following:
     */
    @JvmName("ukeisligwopckqbi")
    public suspend fun textContent(`value`: Output<String>) {
        this.textContent = value
    }

    /**
     * @param value Information about the Amazon S3 bucket containing the application code.
     */
    @JvmName("qljfwdqfyafprpcn")
    public suspend
    fun s3ContentLocation(`value`: ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ContentLocation = mapped
    }

    /**
     * @param argument Information about the Amazon S3 bucket containing the application code.
     */
    @JvmName("claykjgtmkrveoxl")
    public suspend
    fun s3ContentLocation(argument: suspend ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3ContentLocation = mapped
    }

    /**
     * @param value The text-format code for the application.
     * The `s3_content_location` object supports the following:
     */
    @JvmName("vqadunkiwuwccccl")
    public suspend fun textContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.textContent = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs =
        ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs(
            s3ContentLocation = s3ContentLocation,
            textContent = textContent,
        )
}
