@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketArn The ARN for the S3 bucket containing the application code.
 * @property fileKey The file key for the object containing the application code.
 * @property objectVersion The version of the object containing the application code.
 */
public data class
ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs(
    public val bucketArn: Output<String>,
    public val fileKey: Output<String>,
    public val objectVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs.builder()
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .fileKey(fileKey.applyValue({ args0 -> args0 }))
            .objectVersion(objectVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgsBuilder
internal constructor() {
    private var bucketArn: Output<String>? = null

    private var fileKey: Output<String>? = null

    private var objectVersion: Output<String>? = null

    /**
     * @param value The ARN for the S3 bucket containing the application code.
     */
    @JvmName("fobybmaxqfulpcfq")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value The file key for the object containing the application code.
     */
    @JvmName("plfatsmwfoiidxgw")
    public suspend fun fileKey(`value`: Output<String>) {
        this.fileKey = value
    }

    /**
     * @param value The version of the object containing the application code.
     */
    @JvmName("cftwujbrgjhpgtir")
    public suspend fun objectVersion(`value`: Output<String>) {
        this.objectVersion = value
    }

    /**
     * @param value The ARN for the S3 bucket containing the application code.
     */
    @JvmName("mufjfbgwnopfarll")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value The file key for the object containing the application code.
     */
    @JvmName("aflcegfqsexjdyle")
    public suspend fun fileKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileKey = mapped
    }

    /**
     * @param value The version of the object containing the application code.
     */
    @JvmName("elcinpoekpgyavfu")
    public suspend fun objectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectVersion = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs =
        ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationArgs(
            bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
            fileKey = fileKey ?: throw PulumiNullFieldException("fileKey"),
            objectVersion = objectVersion,
        )
}
