@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property snapshotsEnabled Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
 */
public data class ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs(
    public val snapshotsEnabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs.builder()
            .snapshotsEnabled(snapshotsEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgsBuilder internal
constructor() {
    private var snapshotsEnabled: Output<Boolean>? = null

    /**
     * @param value Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     */
    @JvmName("bmumawetpdosddqa")
    public suspend fun snapshotsEnabled(`value`: Output<Boolean>) {
        this.snapshotsEnabled = value
    }

    /**
     * @param value Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     */
    @JvmName("iabbiuuvfnsqgsly")
    public suspend fun snapshotsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotsEnabled = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs =
        ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs(
            snapshotsEnabled = snapshotsEnabled ?: throw PulumiNullFieldException("snapshotsEnabled"),
        )
}
