@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property applicationCodeConfiguration The code location and type parameters for the application.
 * @property applicationSnapshotConfiguration Describes whether snapshots are enabled for a Flink-based application.
 * @property environmentProperties Describes execution properties for a Flink-based application.
 * @property flinkApplicationConfiguration The configuration of a Flink-based application.
 * @property runConfiguration Describes the starting properties for a Flink-based application.
 * @property sqlApplicationConfiguration The configuration of a SQL-based application.
 * @property vpcConfiguration The VPC configuration of a Flink-based application.
 */
public data class ApplicationApplicationConfigurationArgs(
    public val applicationCodeConfiguration:
    Output<ApplicationApplicationConfigurationApplicationCodeConfigurationArgs>,
    public val applicationSnapshotConfiguration:
    Output<ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs>? = null,
    public val environmentProperties:
    Output<ApplicationApplicationConfigurationEnvironmentPropertiesArgs>? = null,
    public val flinkApplicationConfiguration:
    Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs>? = null,
    public val runConfiguration: Output<ApplicationApplicationConfigurationRunConfigurationArgs>? =
        null,
    public val sqlApplicationConfiguration:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationArgs>? = null,
    public val vpcConfiguration: Output<ApplicationApplicationConfigurationVpcConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationArgs.builder()
            .applicationCodeConfiguration(
                applicationCodeConfiguration.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .applicationSnapshotConfiguration(
                applicationSnapshotConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .environmentProperties(
                environmentProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .flinkApplicationConfiguration(
                flinkApplicationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .runConfiguration(runConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sqlApplicationConfiguration(
                sqlApplicationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationArgsBuilder internal constructor() {
    private var applicationCodeConfiguration:
        Output<ApplicationApplicationConfigurationApplicationCodeConfigurationArgs>? = null

    private var applicationSnapshotConfiguration:
        Output<ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs>? = null

    private var environmentProperties:
        Output<ApplicationApplicationConfigurationEnvironmentPropertiesArgs>? = null

    private var flinkApplicationConfiguration:
        Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs>? = null

    private var runConfiguration: Output<ApplicationApplicationConfigurationRunConfigurationArgs>? =
        null

    private var sqlApplicationConfiguration:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationArgs>? = null

    private var vpcConfiguration: Output<ApplicationApplicationConfigurationVpcConfigurationArgs>? =
        null

    /**
     * @param value The code location and type parameters for the application.
     */
    @JvmName("ycufkjjgqkyqxmnu")
    public suspend
    fun applicationCodeConfiguration(`value`: Output<ApplicationApplicationConfigurationApplicationCodeConfigurationArgs>) {
        this.applicationCodeConfiguration = value
    }

    /**
     * @param value Describes whether snapshots are enabled for a Flink-based application.
     */
    @JvmName("ihigbvnoqsxvnjob")
    public suspend
    fun applicationSnapshotConfiguration(`value`: Output<ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs>) {
        this.applicationSnapshotConfiguration = value
    }

    /**
     * @param value Describes execution properties for a Flink-based application.
     */
    @JvmName("wmtyypmdgoxbjofk")
    public suspend
    fun environmentProperties(`value`: Output<ApplicationApplicationConfigurationEnvironmentPropertiesArgs>) {
        this.environmentProperties = value
    }

    /**
     * @param value The configuration of a Flink-based application.
     */
    @JvmName("toyuuxaoetmfvaju")
    public suspend
    fun flinkApplicationConfiguration(`value`: Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs>) {
        this.flinkApplicationConfiguration = value
    }

    /**
     * @param value Describes the starting properties for a Flink-based application.
     */
    @JvmName("sxyymvhwvbhvxlba")
    public suspend
    fun runConfiguration(`value`: Output<ApplicationApplicationConfigurationRunConfigurationArgs>) {
        this.runConfiguration = value
    }

    /**
     * @param value The configuration of a SQL-based application.
     */
    @JvmName("exfagkdxnmpafqsi")
    public suspend
    fun sqlApplicationConfiguration(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationArgs>) {
        this.sqlApplicationConfiguration = value
    }

    /**
     * @param value The VPC configuration of a Flink-based application.
     */
    @JvmName("mkkncyijflodsnrp")
    public suspend
    fun vpcConfiguration(`value`: Output<ApplicationApplicationConfigurationVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value The code location and type parameters for the application.
     */
    @JvmName("opioqubqadtmxmvq")
    public suspend
    fun applicationCodeConfiguration(`value`: ApplicationApplicationConfigurationApplicationCodeConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationCodeConfiguration = mapped
    }

    /**
     * @param argument The code location and type parameters for the application.
     */
    @JvmName("rnybtccghqolinyw")
    public suspend
    fun applicationCodeConfiguration(argument: suspend ApplicationApplicationConfigurationApplicationCodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationApplicationCodeConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.applicationCodeConfiguration = mapped
    }

    /**
     * @param value Describes whether snapshots are enabled for a Flink-based application.
     */
    @JvmName("xpwtyoqggterppgx")
    public suspend
    fun applicationSnapshotConfiguration(`value`: ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSnapshotConfiguration = mapped
    }

    /**
     * @param argument Describes whether snapshots are enabled for a Flink-based application.
     */
    @JvmName("vigghhokaubeeqof")
    public suspend
    fun applicationSnapshotConfiguration(argument: suspend ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationApplicationSnapshotConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.applicationSnapshotConfiguration = mapped
    }

    /**
     * @param value Describes execution properties for a Flink-based application.
     */
    @JvmName("skxkledmqkimhrff")
    public suspend
    fun environmentProperties(`value`: ApplicationApplicationConfigurationEnvironmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentProperties = mapped
    }

    /**
     * @param argument Describes execution properties for a Flink-based application.
     */
    @JvmName("yugsfneufqhbsevt")
    public suspend
    fun environmentProperties(argument: suspend ApplicationApplicationConfigurationEnvironmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationEnvironmentPropertiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.environmentProperties = mapped
    }

    /**
     * @param value The configuration of a Flink-based application.
     */
    @JvmName("qbyowdtegmnknkcl")
    public suspend
    fun flinkApplicationConfiguration(`value`: ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flinkApplicationConfiguration = mapped
    }

    /**
     * @param argument The configuration of a Flink-based application.
     */
    @JvmName("wmvyfevuqutgsgik")
    public suspend
    fun flinkApplicationConfiguration(argument: suspend ApplicationApplicationConfigurationFlinkApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationFlinkApplicationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.flinkApplicationConfiguration = mapped
    }

    /**
     * @param value Describes the starting properties for a Flink-based application.
     */
    @JvmName("refeywojuuyckdgn")
    public suspend
    fun runConfiguration(`value`: ApplicationApplicationConfigurationRunConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runConfiguration = mapped
    }

    /**
     * @param argument Describes the starting properties for a Flink-based application.
     */
    @JvmName("ngnnfwvmwkobxoto")
    public suspend
    fun runConfiguration(argument: suspend ApplicationApplicationConfigurationRunConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationApplicationConfigurationRunConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.runConfiguration = mapped
    }

    /**
     * @param value The configuration of a SQL-based application.
     */
    @JvmName("mnxdyjxjfnrjtdch")
    public suspend
    fun sqlApplicationConfiguration(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlApplicationConfiguration = mapped
    }

    /**
     * @param argument The configuration of a SQL-based application.
     */
    @JvmName("iyppcxrcedrapfwb")
    public suspend
    fun sqlApplicationConfiguration(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sqlApplicationConfiguration = mapped
    }

    /**
     * @param value The VPC configuration of a Flink-based application.
     */
    @JvmName("eepitvoxrdvadqbo")
    public suspend
    fun vpcConfiguration(`value`: ApplicationApplicationConfigurationVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument The VPC configuration of a Flink-based application.
     */
    @JvmName("ogvmijygfartisvn")
    public suspend
    fun vpcConfiguration(argument: suspend ApplicationApplicationConfigurationVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationApplicationConfigurationVpcConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationArgs =
        ApplicationApplicationConfigurationArgs(
            applicationCodeConfiguration = applicationCodeConfiguration ?: throw
                PulumiNullFieldException("applicationCodeConfiguration"),
            applicationSnapshotConfiguration = applicationSnapshotConfiguration,
            environmentProperties = environmentProperties,
            flinkApplicationConfiguration = flinkApplicationConfiguration,
            runConfiguration = runConfiguration,
            sqlApplicationConfiguration = sqlApplicationConfiguration,
            vpcConfiguration = vpcConfiguration,
        )
}
