@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property propertyGroups Describes the execution property groups.
 */
public data class ApplicationApplicationConfigurationEnvironmentPropertiesArgs(
    public val propertyGroups:
    Output<List<ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesArgs.builder()
            .propertyGroups(
                propertyGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationEnvironmentPropertiesArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationEnvironmentPropertiesArgsBuilder internal
constructor() {
    private var propertyGroups:
        Output<List<ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs>>? =
        null

    /**
     * @param value Describes the execution property groups.
     */
    @JvmName("uynrkenwidrqaeqf")
    public suspend
    fun propertyGroups(`value`: Output<List<ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs>>) {
        this.propertyGroups = value
    }

    @JvmName("ucrhhijertgvyvve")
    public suspend fun propertyGroups(
        vararg
        values: Output<ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs>,
    ) {
        this.propertyGroups = Output.all(values.asList())
    }

    /**
     * @param values Describes the execution property groups.
     */
    @JvmName("kstgpfxrljnwthsk")
    public suspend
    fun propertyGroups(values: List<Output<ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs>>) {
        this.propertyGroups = Output.all(values)
    }

    /**
     * @param value Describes the execution property groups.
     */
    @JvmName("xwdhwmgelwcqfmmj")
    public suspend
    fun propertyGroups(`value`: List<ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyGroups = mapped
    }

    /**
     * @param argument Describes the execution property groups.
     */
    @JvmName("kovbxlptbtghtrfm")
    public suspend
    fun propertyGroups(argument: List<suspend ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.propertyGroups = mapped
    }

    /**
     * @param argument Describes the execution property groups.
     */
    @JvmName("ejpqadynwnfldfni")
    public suspend fun propertyGroups(
        vararg
        argument: suspend ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.propertyGroups = mapped
    }

    /**
     * @param argument Describes the execution property groups.
     */
    @JvmName("oefwcsbgnvcrqfjb")
    public suspend
    fun propertyGroups(argument: suspend ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.propertyGroups = mapped
    }

    /**
     * @param values Describes the execution property groups.
     */
    @JvmName("ydmpxaejrqytyhwe")
    public suspend fun propertyGroups(
        vararg
        values: ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyGroups = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationEnvironmentPropertiesArgs =
        ApplicationApplicationConfigurationEnvironmentPropertiesArgs(
            propertyGroups = propertyGroups ?: throw PulumiNullFieldException("propertyGroups"),
        )
}
