@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoScalingEnabled Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
 * @property configurationType Describes whether the application uses the default parallelism for the Kinesis Data Analytics service. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `auto_scaling_enabled`, `parallelism`, or `parallelism_per_kpu` attribute values to be effective.
 * @property parallelism Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform.
 * @property parallelismPerKpu Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
 */
public data class
ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs(
    public val autoScalingEnabled: Output<Boolean>? = null,
    public val configurationType: Output<String>,
    public val parallelism: Output<Int>? = null,
    public val parallelismPerKpu: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs.builder()
            .autoScalingEnabled(autoScalingEnabled?.applyValue({ args0 -> args0 }))
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .parallelism(parallelism?.applyValue({ args0 -> args0 }))
            .parallelismPerKpu(parallelismPerKpu?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgsBuilder
internal constructor() {
    private var autoScalingEnabled: Output<Boolean>? = null

    private var configurationType: Output<String>? = null

    private var parallelism: Output<Int>? = null

    private var parallelismPerKpu: Output<Int>? = null

    /**
     * @param value Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
     */
    @JvmName("wtlncsuscupkylkn")
    public suspend fun autoScalingEnabled(`value`: Output<Boolean>) {
        this.autoScalingEnabled = value
    }

    /**
     * @param value Describes whether the application uses the default parallelism for the Kinesis Data Analytics service. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `auto_scaling_enabled`, `parallelism`, or `parallelism_per_kpu` attribute values to be effective.
     */
    @JvmName("xejtfljaddqqnuuu")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform.
     */
    @JvmName("tsnyaqhabjeuxlvy")
    public suspend fun parallelism(`value`: Output<Int>) {
        this.parallelism = value
    }

    /**
     * @param value Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
     */
    @JvmName("kdlovwekbogmatxf")
    public suspend fun parallelismPerKpu(`value`: Output<Int>) {
        this.parallelismPerKpu = value
    }

    /**
     * @param value Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
     */
    @JvmName("kqyjmjmadviehgin")
    public suspend fun autoScalingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingEnabled = mapped
    }

    /**
     * @param value Describes whether the application uses the default parallelism for the Kinesis Data Analytics service. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `auto_scaling_enabled`, `parallelism`, or `parallelism_per_kpu` attribute values to be effective.
     */
    @JvmName("ndfyxmiawrelgdxk")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform.
     */
    @JvmName("fbeyjumqrfegfeyo")
    public suspend fun parallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelism = mapped
    }

    /**
     * @param value Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
     */
    @JvmName("vafblmojvnonndtj")
    public suspend fun parallelismPerKpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelismPerKpu = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs =
        ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs(
            autoScalingEnabled = autoScalingEnabled,
            configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
            parallelism = parallelism,
            parallelismPerKpu = parallelismPerKpu,
        )
}
