@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationRestoreType Specifies how the application should be restored. Valid values: `RESTORE_FROM_CUSTOM_SNAPSHOT`, `RESTORE_FROM_LATEST_SNAPSHOT`, `SKIP_RESTORE_FROM_SNAPSHOT`.
 * @property snapshotName The identifier of an existing snapshot of application state to use to restart an application. The application uses this value if `RESTORE_FROM_CUSTOM_SNAPSHOT` is specified for `application_restore_type`.
 */
public data class
ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs(
    public val applicationRestoreType: Output<String>? = null,
    public val snapshotName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs.builder()
            .applicationRestoreType(applicationRestoreType?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgsBuilder
internal constructor() {
    private var applicationRestoreType: Output<String>? = null

    private var snapshotName: Output<String>? = null

    /**
     * @param value Specifies how the application should be restored. Valid values: `RESTORE_FROM_CUSTOM_SNAPSHOT`, `RESTORE_FROM_LATEST_SNAPSHOT`, `SKIP_RESTORE_FROM_SNAPSHOT`.
     */
    @JvmName("llvxdrpavkxqafpg")
    public suspend fun applicationRestoreType(`value`: Output<String>) {
        this.applicationRestoreType = value
    }

    /**
     * @param value The identifier of an existing snapshot of application state to use to restart an application. The application uses this value if `RESTORE_FROM_CUSTOM_SNAPSHOT` is specified for `application_restore_type`.
     */
    @JvmName("eshdnevjrcywevms")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value Specifies how the application should be restored. Valid values: `RESTORE_FROM_CUSTOM_SNAPSHOT`, `RESTORE_FROM_LATEST_SNAPSHOT`, `SKIP_RESTORE_FROM_SNAPSHOT`.
     */
    @JvmName("thdflwsutcrryaif")
    public suspend fun applicationRestoreType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationRestoreType = mapped
    }

    /**
     * @param value The identifier of an existing snapshot of application state to use to restart an application. The application uses this value if `RESTORE_FROM_CUSTOM_SNAPSHOT` is specified for `application_restore_type`.
     */
    @JvmName("byfvnvpuwfjkrgro")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs =
        ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs(
            applicationRestoreType = applicationRestoreType,
            snapshotName = snapshotName,
        )
}
