@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property applicationRestoreConfiguration The restore behavior of a restarting application.
 * @property flinkRunConfiguration The starting parameters for a Flink-based Kinesis Data Analytics application.
 */
public data class ApplicationApplicationConfigurationRunConfigurationArgs(
    public val applicationRestoreConfiguration:
    Output<ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs>? =
        null,
    public val flinkRunConfiguration:
    Output<ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationArgs.builder()
            .applicationRestoreConfiguration(
                applicationRestoreConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .flinkRunConfiguration(
                flinkRunConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationRunConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationRunConfigurationArgsBuilder internal constructor() {
    private var applicationRestoreConfiguration:
        Output<ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs>? =
        null

    private var flinkRunConfiguration:
        Output<ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs>? = null

    /**
     * @param value The restore behavior of a restarting application.
     */
    @JvmName("xyuhxvhmdikftdsb")
    public suspend
    fun applicationRestoreConfiguration(`value`: Output<ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs>) {
        this.applicationRestoreConfiguration = value
    }

    /**
     * @param value The starting parameters for a Flink-based Kinesis Data Analytics application.
     */
    @JvmName("llgsjarcaiakenjk")
    public suspend
    fun flinkRunConfiguration(`value`: Output<ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs>) {
        this.flinkRunConfiguration = value
    }

    /**
     * @param value The restore behavior of a restarting application.
     */
    @JvmName("qjiitbiikdjkokft")
    public suspend
    fun applicationRestoreConfiguration(`value`: ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationRestoreConfiguration = mapped
    }

    /**
     * @param argument The restore behavior of a restarting application.
     */
    @JvmName("dftsndustlyrybcd")
    public suspend
    fun applicationRestoreConfiguration(argument: suspend ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.applicationRestoreConfiguration = mapped
    }

    /**
     * @param value The starting parameters for a Flink-based Kinesis Data Analytics application.
     */
    @JvmName("vgspbuywjovetdbh")
    public suspend
    fun flinkRunConfiguration(`value`: ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flinkRunConfiguration = mapped
    }

    /**
     * @param argument The starting parameters for a Flink-based Kinesis Data Analytics application.
     */
    @JvmName("mruwcuesypoeysud")
    public suspend
    fun flinkRunConfiguration(argument: suspend ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.flinkRunConfiguration = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationRunConfigurationArgs =
        ApplicationApplicationConfigurationRunConfigurationArgs(
            applicationRestoreConfiguration = applicationRestoreConfiguration,
            flinkRunConfiguration = flinkRunConfiguration,
        )
}
