@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property input The input stream used by the application.
 * @property outputs The destination streams used by the application.
 * @property referenceDataSource The reference data source used by the application.
 */
public data class ApplicationApplicationConfigurationSqlApplicationConfigurationArgs(
    public val input: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs>? =
        null,
    public val outputs:
    Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs>>? =
        null,
    public val referenceDataSource:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationArgs.builder()
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .referenceDataSource(
                referenceDataSource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationSqlApplicationConfigurationArgsBuilder internal
constructor() {
    private var input:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs>? = null

    private var outputs:
        Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs>>? = null

    private var referenceDataSource:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs>? =
        null

    /**
     * @param value The input stream used by the application.
     */
    @JvmName("esojyevrlcxthwgs")
    public suspend
    fun input(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs>) {
        this.input = value
    }

    /**
     * @param value The destination streams used by the application.
     */
    @JvmName("mqlqvnrceylbovrj")
    public suspend
    fun outputs(`value`: Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs>>) {
        this.outputs = value
    }

    @JvmName("autnmqkujqudutfq")
    public suspend fun outputs(
        vararg
        values: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs>,
    ) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values The destination streams used by the application.
     */
    @JvmName("wkkbymmqxtbybnup")
    public suspend
    fun outputs(values: List<Output<ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value The reference data source used by the application.
     */
    @JvmName("dlishvtjyxttaype")
    public suspend
    fun referenceDataSource(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs>) {
        this.referenceDataSource = value
    }

    /**
     * @param value The input stream used by the application.
     */
    @JvmName("hnjfqchxnxgixxjr")
    public suspend
    fun input(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument The input stream used by the application.
     */
    @JvmName("nhvqdwggxxpsqywf")
    public suspend
    fun input(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value The destination streams used by the application.
     */
    @JvmName("xdqvrlvebqoesytn")
    public suspend
    fun outputs(`value`: List<ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument The destination streams used by the application.
     */
    @JvmName("thjbkbhiwurbekve")
    public suspend
    fun outputs(argument: List<suspend ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument The destination streams used by the application.
     */
    @JvmName("vppdltsajfwbmjcq")
    public suspend fun outputs(
        vararg
        argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument The destination streams used by the application.
     */
    @JvmName("ctqcdxmdjkrjcqxp")
    public suspend
    fun outputs(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values The destination streams used by the application.
     */
    @JvmName("qbrlvaaisoueyuyr")
    public suspend fun outputs(
        vararg
        values: ApplicationApplicationConfigurationSqlApplicationConfigurationOutputArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The reference data source used by the application.
     */
    @JvmName("bqmbxruokdktsoen")
    public suspend
    fun referenceDataSource(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceDataSource = mapped
    }

    /**
     * @param argument The reference data source used by the application.
     */
    @JvmName("gbfmisammvygomna")
    public suspend
    fun referenceDataSource(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.referenceDataSource = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationSqlApplicationConfigurationArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationArgs(
            input = input,
            outputs = outputs,
            referenceDataSource = referenceDataSource,
        )
}
