@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property inAppStreamNames
 * @property inputId
 * @property inputParallelism Describes the number of in-application streams to create.
 * @property inputProcessingConfiguration The input processing configuration for the input.
 * An input processor transforms records as they are received from the stream, before the application's SQL code executes.
 * @property inputSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
 * @property inputStartingPositionConfigurations The point at which the application starts processing records from the streaming source.
 * @property kinesisFirehoseInput If the streaming source is a Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
 * @property kinesisStreamsInput If the streaming source is a Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
 * @property namePrefix The name prefix to use when creating an in-application stream.
 */
public data class ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs(
    public val inAppStreamNames: Output<List<String>>? = null,
    public val inputId: Output<String>? = null,
    public val inputParallelism:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs>? =
        null,
    public val inputProcessingConfiguration:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs>? =
        null,
    public val inputSchema:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs>,
    public val inputStartingPositionConfigurations:
    Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgs>>? =
        null,
    public val kinesisFirehoseInput:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs>? =
        null,
    public val kinesisStreamsInput:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs>? =
        null,
    public val namePrefix: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs.builder()
            .inAppStreamNames(inAppStreamNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inputId(inputId?.applyValue({ args0 -> args0 }))
            .inputParallelism(inputParallelism?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputProcessingConfiguration(
                inputProcessingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .inputSchema(inputSchema.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputStartingPositionConfigurations(
                inputStartingPositionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kinesisFirehoseInput(
                kinesisFirehoseInput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kinesisStreamsInput(
                kinesisStreamsInput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .namePrefix(namePrefix.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgsBuilder internal
constructor() {
    private var inAppStreamNames: Output<List<String>>? = null

    private var inputId: Output<String>? = null

    private var inputParallelism:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs>? =
        null

    private var inputProcessingConfiguration:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs>? =
        null

    private var inputSchema:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs>? =
        null

    private var inputStartingPositionConfigurations:
        Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgs>>? =
        null

    private var kinesisFirehoseInput:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs>? =
        null

    private var kinesisStreamsInput:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs>? =
        null

    private var namePrefix: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("cwjdafirbbjiqesp")
    public suspend fun inAppStreamNames(`value`: Output<List<String>>) {
        this.inAppStreamNames = value
    }

    @JvmName("sqalbspafrxsvlbc")
    public suspend fun inAppStreamNames(vararg values: Output<String>) {
        this.inAppStreamNames = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("quwxoqatkivulopi")
    public suspend fun inAppStreamNames(values: List<Output<String>>) {
        this.inAppStreamNames = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("nfttwidshqcnboen")
    public suspend fun inputId(`value`: Output<String>) {
        this.inputId = value
    }

    /**
     * @param value Describes the number of in-application streams to create.
     */
    @JvmName("nckyvjqyoynmpsrk")
    public suspend
    fun inputParallelism(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs>) {
        this.inputParallelism = value
    }

    /**
     * @param value The input processing configuration for the input.
     * An input processor transforms records as they are received from the stream, before the application's SQL code executes.
     */
    @JvmName("ivdfyerfjrincoyo")
    public suspend
    fun inputProcessingConfiguration(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs>) {
        this.inputProcessingConfiguration = value
    }

    /**
     * @param value Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
     */
    @JvmName("cuifqpbixnidqchy")
    public suspend
    fun inputSchema(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs>) {
        this.inputSchema = value
    }

    /**
     * @param value The point at which the application starts processing records from the streaming source.
     */
    @JvmName("dxlpunikhiesxtyk")
    public suspend
    fun inputStartingPositionConfigurations(`value`: Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgs>>) {
        this.inputStartingPositionConfigurations = value
    }

    @JvmName("iayysubqlfdcmnvj")
    public suspend fun inputStartingPositionConfigurations(
        vararg
        values: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgs>,
    ) {
        this.inputStartingPositionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The point at which the application starts processing records from the streaming source.
     */
    @JvmName("flbecyisuqqxijwo")
    public suspend
    fun inputStartingPositionConfigurations(values: List<Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgs>>) {
        this.inputStartingPositionConfigurations = Output.all(values)
    }

    /**
     * @param value If the streaming source is a Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
     */
    @JvmName("ktkekwyampdwdjrt")
    public suspend
    fun kinesisFirehoseInput(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs>) {
        this.kinesisFirehoseInput = value
    }

    /**
     * @param value If the streaming source is a Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
     */
    @JvmName("hdwoqompjbrvcqaq")
    public suspend
    fun kinesisStreamsInput(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs>) {
        this.kinesisStreamsInput = value
    }

    /**
     * @param value The name prefix to use when creating an in-application stream.
     */
    @JvmName("bvovilnyfjqrsppk")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("qhmiyehpgxfhbeut")
    public suspend fun inAppStreamNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inAppStreamNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("fjamrmyrlwglocxt")
    public suspend fun inAppStreamNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inAppStreamNames = mapped
    }

    /**
     * @param value
     */
    @JvmName("gkxwoitwswsxxalr")
    public suspend fun inputId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputId = mapped
    }

    /**
     * @param value Describes the number of in-application streams to create.
     */
    @JvmName("cijophhcdarngfac")
    public suspend
    fun inputParallelism(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParallelism = mapped
    }

    /**
     * @param argument Describes the number of in-application streams to create.
     */
    @JvmName("bdymlolyjyxwsbxy")
    public suspend
    fun inputParallelism(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelismArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inputParallelism = mapped
    }

    /**
     * @param value The input processing configuration for the input.
     * An input processor transforms records as they are received from the stream, before the application's SQL code executes.
     */
    @JvmName("rhpvxcvskiavnbmx")
    public suspend
    fun inputProcessingConfiguration(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputProcessingConfiguration = mapped
    }

    /**
     * @param argument The input processing configuration for the input.
     * An input processor transforms records as they are received from the stream, before the application's SQL code executes.
     */
    @JvmName("fvhpubithxmwefog")
    public suspend
    fun inputProcessingConfiguration(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inputProcessingConfiguration = mapped
    }

    /**
     * @param value Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
     */
    @JvmName("vrmykqsebrwyygyk")
    public suspend
    fun inputSchema(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param argument Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
     */
    @JvmName("apfuejdqcvacgrdu")
    public suspend
    fun inputSchema(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inputSchema = mapped
    }

    /**
     * @param value The point at which the application starts processing records from the streaming source.
     */
    @JvmName("eppunjtijljyodpu")
    public suspend
    fun inputStartingPositionConfigurations(`value`: List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputStartingPositionConfigurations = mapped
    }

    /**
     * @param argument The point at which the application starts processing records from the streaming source.
     */
    @JvmName("lgvijiibptfiwgux")
    public suspend
    fun inputStartingPositionConfigurations(argument: List<suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputStartingPositionConfigurations = mapped
    }

    /**
     * @param argument The point at which the application starts processing records from the streaming source.
     */
    @JvmName("mvccdpigickeybyt")
    public suspend fun inputStartingPositionConfigurations(
        vararg
        argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputStartingPositionConfigurations = mapped
    }

    /**
     * @param argument The point at which the application starts processing records from the streaming source.
     */
    @JvmName("ufnrjhheynahosrm")
    public suspend
    fun inputStartingPositionConfigurations(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.inputStartingPositionConfigurations = mapped
    }

    /**
     * @param values The point at which the application starts processing records from the streaming source.
     */
    @JvmName("xvgrbqvkgqttrwqk")
    public suspend fun inputStartingPositionConfigurations(
        vararg
        values: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputStartingPositionConfigurations = mapped
    }

    /**
     * @param value If the streaming source is a Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
     */
    @JvmName("fwnifwwlsjkgqpdb")
    public suspend
    fun kinesisFirehoseInput(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisFirehoseInput = mapped
    }

    /**
     * @param argument If the streaming source is a Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
     */
    @JvmName("fdhddnjtysqofuui")
    public suspend
    fun kinesisFirehoseInput(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisFirehoseInput = mapped
    }

    /**
     * @param value If the streaming source is a Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
     */
    @JvmName("pueuljuhdjfwqyci")
    public suspend
    fun kinesisStreamsInput(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisStreamsInput = mapped
    }

    /**
     * @param argument If the streaming source is a Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
     */
    @JvmName("falpusmrxxodgwgh")
    public suspend
    fun kinesisStreamsInput(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisStreamsInput = mapped
    }

    /**
     * @param value The name prefix to use when creating an in-application stream.
     */
    @JvmName("khfaxlsavtbbrfbo")
    public suspend fun namePrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputArgs(
            inAppStreamNames = inAppStreamNames,
            inputId = inputId,
            inputParallelism = inputParallelism,
            inputProcessingConfiguration = inputProcessingConfiguration,
            inputSchema = inputSchema ?: throw PulumiNullFieldException("inputSchema"),
            inputStartingPositionConfigurations = inputStartingPositionConfigurations,
            kinesisFirehoseInput = kinesisFirehoseInput,
            kinesisStreamsInput = kinesisStreamsInput,
            namePrefix = namePrefix ?: throw PulumiNullFieldException("namePrefix"),
        )
}
