@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property inputLambdaProcessor Describes the Lambda function that is used to preprocess the records in the stream before being processed by your application code.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs(
    public val inputLambdaProcessor:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationInputLambdaProcessorArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs.builder()
            .inputLambdaProcessor(
                inputLambdaProcessor.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgsBuilder
internal constructor() {
    private var inputLambdaProcessor:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationInputLambdaProcessorArgs>? =
        null

    /**
     * @param value Describes the Lambda function that is used to preprocess the records in the stream before being processed by your application code.
     */
    @JvmName("wexclinylsifqqfw")
    public suspend
    fun inputLambdaProcessor(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationInputLambdaProcessorArgs>) {
        this.inputLambdaProcessor = value
    }

    /**
     * @param value Describes the Lambda function that is used to preprocess the records in the stream before being processed by your application code.
     */
    @JvmName("firxbjvjatjwxkjm")
    public suspend
    fun inputLambdaProcessor(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationInputLambdaProcessorArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputLambdaProcessor = mapped
    }

    /**
     * @param argument Describes the Lambda function that is used to preprocess the records in the stream before being processed by your application code.
     */
    @JvmName("ctuverlrdkuhhbek")
    public suspend
    fun inputLambdaProcessor(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationInputLambdaProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationInputLambdaProcessorArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inputLambdaProcessor = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfigurationArgs(
            inputLambdaProcessor = inputLambdaProcessor ?: throw
                PulumiNullFieldException("inputLambdaProcessor"),
        )
}
