@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property recordColumns Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
 * @property recordEncoding Specifies the encoding of the records in the streaming source. For example, `UTF-8`.
 * @property recordFormat Specifies the format of the records on the streaming source.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs(
    public val recordColumns:
    Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs>>,
    public val recordEncoding: Output<String>? = null,
    public val recordFormat:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs.builder()
            .recordColumns(
                recordColumns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recordEncoding(recordEncoding?.applyValue({ args0 -> args0 }))
            .recordFormat(recordFormat.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgsBuilder
internal constructor() {
    private var recordColumns:
        Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs>>? =
        null

    private var recordEncoding: Output<String>? = null

    private var recordFormat:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs>? =
        null

    /**
     * @param value Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("hqnckhvgxabirerl")
    public suspend
    fun recordColumns(`value`: Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs>>) {
        this.recordColumns = value
    }

    @JvmName("stniybeitgbylvjl")
    public suspend fun recordColumns(
        vararg
        values: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs>,
    ) {
        this.recordColumns = Output.all(values.asList())
    }

    /**
     * @param values Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("qkdwhiwiknrbuoyq")
    public suspend
    fun recordColumns(values: List<Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs>>) {
        this.recordColumns = Output.all(values)
    }

    /**
     * @param value Specifies the encoding of the records in the streaming source. For example, `UTF-8`.
     */
    @JvmName("yifyukknrpnegbym")
    public suspend fun recordEncoding(`value`: Output<String>) {
        this.recordEncoding = value
    }

    /**
     * @param value Specifies the format of the records on the streaming source.
     */
    @JvmName("mkxokcqvagahhpwn")
    public suspend
    fun recordFormat(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs>) {
        this.recordFormat = value
    }

    /**
     * @param value Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("uiivmleqgjswjdpe")
    public suspend
    fun recordColumns(`value`: List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param argument Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("mbryctlrvdcgrudk")
    public suspend
    fun recordColumns(argument: List<suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("qwlqnwbokoxftnyx")
    public suspend fun recordColumns(
        vararg
        argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("rhbkxlkjutcoaaph")
    public suspend
    fun recordColumns(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param values Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("rqfepiqenrycbjel")
    public suspend fun recordColumns(
        vararg
        values: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumnArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param value Specifies the encoding of the records in the streaming source. For example, `UTF-8`.
     */
    @JvmName("piqxnphjgrhbkaet")
    public suspend fun recordEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordEncoding = mapped
    }

    /**
     * @param value Specifies the format of the records on the streaming source.
     */
    @JvmName("cwlwllnksqvgenth")
    public suspend
    fun recordFormat(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordFormat = mapped
    }

    /**
     * @param argument Specifies the format of the records on the streaming source.
     */
    @JvmName("feoymtkeupavjwoa")
    public suspend
    fun recordFormat(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.recordFormat = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaArgs(
            recordColumns = recordColumns ?: throw PulumiNullFieldException("recordColumns"),
            recordEncoding = recordEncoding,
            recordFormat = recordFormat ?: throw PulumiNullFieldException("recordFormat"),
        )
}
