@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property mappingParameters Provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
 * @property recordFormatType The type of record format. Valid values: `CSV`, `JSON`.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs(
    public val mappingParameters:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs>,
    public val recordFormatType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs.builder()
            .mappingParameters(mappingParameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recordFormatType(recordFormatType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgsBuilder
internal constructor() {
    private var mappingParameters:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs>? =
        null

    private var recordFormatType: Output<String>? = null

    /**
     * @param value Provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
     */
    @JvmName("yiboducieqwfayff")
    public suspend
    fun mappingParameters(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs>) {
        this.mappingParameters = value
    }

    /**
     * @param value The type of record format. Valid values: `CSV`, `JSON`.
     */
    @JvmName("cyiruiuldypelxan")
    public suspend fun recordFormatType(`value`: Output<String>) {
        this.recordFormatType = value
    }

    /**
     * @param value Provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
     */
    @JvmName("tufqsfujncvcpdgm")
    public suspend
    fun mappingParameters(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappingParameters = mapped
    }

    /**
     * @param argument Provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
     */
    @JvmName("fsnqsuhldcwnfset")
    public suspend
    fun mappingParameters(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.mappingParameters = mapped
    }

    /**
     * @param value The type of record format. Valid values: `CSV`, `JSON`.
     */
    @JvmName("lxprqtlfehljdijd")
    public suspend fun recordFormatType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordFormatType = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatArgs(
            mappingParameters = mappingParameters ?: throw PulumiNullFieldException("mappingParameters"),
            recordFormatType = recordFormatType ?: throw PulumiNullFieldException("recordFormatType"),
        )
}
