@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceArn The ARN of the delivery stream.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs(
    public val resourceArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs.builder()
            .resourceArn(resourceArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgsBuilder
internal constructor() {
    private var resourceArn: Output<String>? = null

    /**
     * @param value The ARN of the delivery stream.
     */
    @JvmName("lqkbttempkyxmjdi")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The ARN of the delivery stream.
     */
    @JvmName("duqejwbdnoiucssw")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInputArgs(
            resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
        )
}
