@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property referenceId
 * @property referenceSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
 * @property s3ReferenceDataSource Identifies the S3 bucket and object that contains the reference data.
 * @property tableName The name of the in-application table to create.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs(
    public val referenceId: Output<String>? = null,
    public val referenceSchema:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs>,
    public val s3ReferenceDataSource:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs>,
    public val tableName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs.builder()
            .referenceId(referenceId?.applyValue({ args0 -> args0 }))
            .referenceSchema(referenceSchema.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3ReferenceDataSource(
                s3ReferenceDataSource.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgsBuilder
internal constructor() {
    private var referenceId: Output<String>? = null

    private var referenceSchema:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs>? =
        null

    private var s3ReferenceDataSource:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs>? =
        null

    private var tableName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("jgypegrldscrqjud")
    public suspend fun referenceId(`value`: Output<String>) {
        this.referenceId = value
    }

    /**
     * @param value Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     */
    @JvmName("yiigransynkljtgi")
    public suspend
    fun referenceSchema(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs>) {
        this.referenceSchema = value
    }

    /**
     * @param value Identifies the S3 bucket and object that contains the reference data.
     */
    @JvmName("uwwsylqppqlushmi")
    public suspend
    fun s3ReferenceDataSource(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs>) {
        this.s3ReferenceDataSource = value
    }

    /**
     * @param value The name of the in-application table to create.
     */
    @JvmName("qmrhnjkvnqgmcuci")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value
     */
    @JvmName("fiownsctkqjtuwai")
    public suspend fun referenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceId = mapped
    }

    /**
     * @param value Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     */
    @JvmName("rfnbghdwmwjvncrv")
    public suspend
    fun referenceSchema(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceSchema = mapped
    }

    /**
     * @param argument Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     */
    @JvmName("iwkbdvibkkaismro")
    public suspend
    fun referenceSchema(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.referenceSchema = mapped
    }

    /**
     * @param value Identifies the S3 bucket and object that contains the reference data.
     */
    @JvmName("aslmduksqsuvdatn")
    public suspend
    fun s3ReferenceDataSource(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3ReferenceDataSource = mapped
    }

    /**
     * @param argument Identifies the S3 bucket and object that contains the reference data.
     */
    @JvmName("tdgmibramyhkrtgf")
    public suspend
    fun s3ReferenceDataSource(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3ReferenceDataSource = mapped
    }

    /**
     * @param value The name of the in-application table to create.
     */
    @JvmName("imsobkfhvyrptxva")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceArgs(
            referenceId = referenceId,
            referenceSchema = referenceSchema ?: throw PulumiNullFieldException("referenceSchema"),
            s3ReferenceDataSource = s3ReferenceDataSource ?: throw
                PulumiNullFieldException("s3ReferenceDataSource"),
            tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        )
}
