@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
 * @property jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs(
    public val csvMappingParameters:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs>? =
        null,
    public val jsonMappingParameters:
    Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs.builder()
            .csvMappingParameters(
                csvMappingParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jsonMappingParameters(
                jsonMappingParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgsBuilder
internal constructor() {
    private var csvMappingParameters:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs>? =
        null

    private var jsonMappingParameters:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs>? =
        null

    /**
     * @param value Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    @JvmName("lanbsqtpthoifjre")
    public suspend
    fun csvMappingParameters(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs>) {
        this.csvMappingParameters = value
    }

    /**
     * @param value Provides additional mapping information when JSON is the record format on the streaming source.
     */
    @JvmName("cntoegdwbmegpiea")
    public suspend
    fun jsonMappingParameters(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs>) {
        this.jsonMappingParameters = value
    }

    /**
     * @param value Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    @JvmName("jflrvknlpqskyfxw")
    public suspend
    fun csvMappingParameters(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvMappingParameters = mapped
    }

    /**
     * @param argument Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    @JvmName("iknfvwegljgavjpn")
    public suspend
    fun csvMappingParameters(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.csvMappingParameters = mapped
    }

    /**
     * @param value Provides additional mapping information when JSON is the record format on the streaming source.
     */
    @JvmName("sopdsjpnfmjknsnm")
    public suspend
    fun jsonMappingParameters(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonMappingParameters = mapped
    }

    /**
     * @param argument Provides additional mapping information when JSON is the record format on the streaming source.
     */
    @JvmName("sleasepfmtingmwq")
    public suspend
    fun jsonMappingParameters(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJsonMappingParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonMappingParameters = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersArgs(
            csvMappingParameters = csvMappingParameters,
            jsonMappingParameters = jsonMappingParameters,
        )
}
